/*
 * Decompiled with CFR 0.152.
 */
package requious.data;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import requious.Registry;
import requious.block.BlockAssembly;
import requious.compat.crafttweaker.ComponentFaceCT;
import requious.compat.crafttweaker.MachineVisualCT;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.compat.jei.JEISlot;
import requious.compat.jei.slot.DecorationSlot;
import requious.compat.jei.slot.DurationSlot;
import requious.compat.jei.slot.EnergySlot;
import requious.compat.jei.slot.FluidSlot;
import requious.compat.jei.slot.ItemSlot;
import requious.compat.jei.slot.JEIInfoSlot;
import requious.compat.jei.slot.LaserSlot;
import requious.compat.jei.slot.SelectionSlot;
import requious.data.AssemblyProcessor;
import requious.data.BaseData;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentDecoration;
import requious.data.component.ComponentDuration;
import requious.data.component.ComponentEnergy;
import requious.data.component.ComponentFluid;
import requious.data.component.ComponentItem;
import requious.data.component.ComponentLaser;
import requious.data.component.ComponentSelection;
import requious.data.component.ComponentText;
import requious.recipe.AssemblyJEIWrapper;
import requious.recipe.AssemblyRecipe;
import requious.util.LayerType;
import requious.util.MachineVisual;
import requious.util.PlaceType;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.Assembly")
public class AssemblyData
extends BaseData {
    @Expose(serialize=false, deserialize=false)
    public transient ComponentBase[][] slots = new ComponentBase[9][5];
    @Expose(serialize=false, deserialize=false)
    public transient Map<String, List<AssemblyRecipe>> recipes = new HashMap<String, List<AssemblyRecipe>>();
    public PlaceType placeType = PlaceType.Any;
    public LayerType layerType = LayerType.Cutout;
    public boolean hasGUI = true;
    public String[] extraVariants = new String[0];
    @Expose(serialize=false, deserialize=false)
    public transient List<JEISlot> jeiSlots = new ArrayList<JEISlot>();
    @Expose(serialize=false, deserialize=false)
    public transient List<AssemblyRecipe> jeiRecipes = new ArrayList<AssemblyRecipe>();
    @Expose(serialize=false, deserialize=false)
    public transient List<ItemStack> jeiCatalysts = new ArrayList<ItemStack>();
    @Expose(serialize=false, deserialize=false)
    private transient BlockAssembly block;
    @Expose(serialize=false, deserialize=false)
    private transient List<MachineVisual> visuals = new ArrayList<MachineVisual>();

    public AssemblyProcessor constructProcessor() {
        AssemblyProcessor processor = new AssemblyProcessor(this);
        processor.setComponent(this.slots);
        processor.setup();
        return processor;
    }

    public Collection<AssemblyJEIWrapper> getJeiWrappers() {
        return this.jeiRecipes.stream().map(AssemblyJEIWrapper::new).collect(Collectors.toList());
    }

    public void setBlock(BlockAssembly block) {
        this.block = block;
    }

    public BlockAssembly getBlock() {
        return this.block;
    }

    public List<MachineVisual> getVisuals() {
        return this.visuals;
    }

    @ZenMethod
    public static AssemblyData get(String identifier) {
        return Registry.getAssemblyData(identifier);
    }

    private void setSlot(int x, int y, ComponentBase component) {
        this.slots[x][y] = component;
        component.setPosition(x, y);
    }

    private void setJEISlot(JEISlot slot) {
        this.jeiSlots.removeIf(oldSlot -> slot.x == oldSlot.x && slot.y == oldSlot.y);
        this.jeiSlots.add(slot);
    }

    public int getJEIWidth() {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (JEISlot slot : this.jeiSlots) {
            min = Math.min(min, slot.x);
            max = Math.max(max, slot.x + 1);
        }
        return max - min;
    }

    public int getJEIHeight() {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (JEISlot slot : this.jeiSlots) {
            min = Math.min(min, slot.y);
            max = Math.max(max, slot.y + 1);
        }
        return max - min;
    }

    @ZenMethod
    public ComponentItem setItemSlot(int x, int y, ComponentFaceCT face, int capacity) {
        ComponentItem component = new ComponentItem(face.get(), capacity);
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentFluid setFluidSlot(int x, int y, ComponentFaceCT face, int capacity) {
        ComponentFluid component = new ComponentFluid(face.get(), capacity);
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentEnergy setEnergySlot(int x, int y, ComponentFaceCT face, int capacity) {
        ComponentEnergy component = new ComponentEnergy(face.get(), capacity);
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentLaser setLaserSlot(int x, int y, ComponentFaceCT face) {
        ComponentLaser component = new ComponentLaser(face.get());
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentSelection setSelectionSlot(int x, int y, String selectionGroup, int index) {
        ComponentSelection component = new ComponentSelection(selectionGroup, index);
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentDuration setDurationSlot(int x, int y) {
        ComponentDuration component = new ComponentDuration();
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentDecoration setDecorationSlot(int x, int y, SlotVisualCT visual) {
        ComponentDecoration component = new ComponentDecoration(SlotVisualCT.unpack(visual));
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public ComponentText setTextSlot(int x, int y) {
        ComponentText component = new ComponentText();
        this.setSlot(x, y, component);
        return component;
    }

    @ZenMethod
    public void addVisual(MachineVisualCT visual) {
        this.visuals.add(visual.get());
    }

    @ZenMethod
    public void addRecipe(AssemblyRecipe recipe) {
        this.recipes.computeIfAbsent(recipe.processGroup, k -> new ArrayList()).add(recipe);
    }

    @ZenMethod
    public void setJEIItemSlot(int x, int y, String group, @Optional SlotVisualCT visual) {
        this.setJEISlot(new ItemSlot(x, y, group, SlotVisualCT.unpack(visual)));
    }

    @ZenMethod
    public void setJEIFluidSlot(int x, int y, String group) {
        this.setJEISlot(new FluidSlot(x, y, group));
    }

    @ZenMethod
    public void setJEIEnergySlot(int x, int y, String group, @Optional String unit) {
        if (unit == null) {
            unit = "none";
        }
        this.setJEISlot(new EnergySlot(x, y, group, unit));
    }

    @ZenMethod
    public void setJEILaserSlot(int x, int y, String group) {
        this.setJEISlot(new LaserSlot(x, y, group));
    }

    @ZenMethod
    public void setJEISelectionSlot(int x, int y, String group, @Optional SlotVisualCT visual) {
        this.setJEISlot(new SelectionSlot(x, y, group, SlotVisualCT.unpack(visual)));
    }

    @ZenMethod
    public void setJEIDecoration(int x, int y, String group, @Optional SlotVisualCT visual) {
        this.setJEISlot(new DecorationSlot(x, y, group, SlotVisualCT.unpack(visual)));
    }

    @ZenMethod
    public void setJEIDurationSlot(int x, int y, String group, SlotVisualCT visual) {
        this.setJEISlot(new DurationSlot(x, y, group, SlotVisualCT.unpack(visual)));
    }

    @ZenMethod
    public void setJEIInfoSlot(int x, int y, String group) {
        this.setJEISlot(new JEIInfoSlot(x, y, group));
    }

    @ZenMethod
    public void addJEIRecipe(AssemblyRecipe recipe) {
        if (recipe.hasJEICategory()) {
            CraftTweakerAPI.logError((String)"Recipe already has a JEI category.");
            return;
        }
        this.jeiRecipes.add(recipe);
        recipe.setJEICategory(this);
    }

    @ZenMethod
    public void addJEICatalyst(IItemStack catalyst) {
        this.jeiCatalysts.add(CraftTweakerMC.getItemStack((IItemStack)catalyst));
    }

    public Iterable<ItemStack> getJEICatalysts() {
        if (this.jeiCatalysts.isEmpty()) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this.getBlock())});
        }
        return this.jeiCatalysts;
    }

    public boolean hasJEIRecipes() {
        return !this.jeiRecipes.isEmpty();
    }

    public void compactJEI() {
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        for (JEISlot slot : this.jeiSlots) {
            minX = Math.min(minX, slot.x);
            maxX = Math.max(maxX, slot.x + 1);
            minY = Math.min(minY, slot.y);
            maxY = Math.max(maxY, slot.y + 1);
        }
        for (JEISlot slot : this.jeiSlots) {
            slot.x -= minX;
            slot.y -= minY;
        }
    }
}

