/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei.slot;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.jei.IngredientCollector;
import requious.compat.jei.JEISlot;
import requious.util.Misc;

public class FluidSlot
extends JEISlot {
    public List<FluidStack> fluids = new ArrayList<FluidStack>();
    public FillNormalizer normalizer = new FillNormalizer();

    public FluidSlot(int x, int y, String group) {
        super(x, y, group);
    }

    @Override
    public boolean isFilled() {
        return !this.fluids.isEmpty();
    }

    @Override
    public void resetFill() {
        super.resetFill();
        this.fluids.clear();
    }

    public void addFluid(FluidStack fluid) {
        this.fluids.add(fluid);
        this.normalizer.add(fluid.amount);
    }

    @Override
    public JEISlot copy() {
        FluidSlot fluidSlot = new FluidSlot(this.x, this.y, this.group);
        fluidSlot.normalizer = this.normalizer;
        return fluidSlot;
    }

    @Override
    public void getIngredients(IngredientCollector collector) {
        for (FluidStack fluid : this.fluids) {
            if (this.isInput()) {
                collector.addInput(VanillaTypes.FLUID, fluid);
                continue;
            }
            collector.addOutput(VanillaTypes.FLUID, fluid);
        }
    }

    @Override
    public void render(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("requious", "textures/gui/assembly_slots.png"));
        Misc.drawTexturedModalRect(this.x * 18, this.y * 18, 18, 0, 18, 18);
    }

    public static class FillNormalizer {
        int highestFill;

        public void add(int amount) {
            if (amount > this.highestFill) {
                this.highestFill = amount;
            }
        }

        public int get() {
            return this.highestFill;
        }
    }
}

