/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.util.Translator;
import requious.compat.jei.JEISlot;
import requious.compat.jei.ingredient.IngredientTypes;
import requious.compat.jei.ingredient.SuperStackRenderer;
import requious.compat.jei.slot.EnergySlot;
import requious.compat.jei.slot.FluidSlot;
import requious.compat.jei.slot.ItemSlot;
import requious.compat.jei.slot.JEIInfoSlot;
import requious.compat.jei.slot.LaserSlot;
import requious.data.AssemblyData;
import requious.recipe.AssemblyJEIWrapper;

public class AssemblyCategory
implements IRecipeCategory<AssemblyJEIWrapper> {
    @Nonnull
    private final String uid;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    private final AssemblyData assembly;
    private final IGuiHelper guiHelper;
    SuperStackRenderer stackRenderer = new SuperStackRenderer();

    public AssemblyCategory(AssemblyData assembly, IGuiHelper guiHelper) {
        this.uid = "requious." + assembly.resourceName;
        this.localizedName = Translator.translateToLocal((String)("requious.jei.recipe." + assembly.resourceName));
        this.assembly = assembly;
        this.guiHelper = guiHelper;
        this.background = guiHelper.createBlankDrawable(assembly.getJEIWidth() * 18, assembly.getJEIHeight() * 18);
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Requious Frakto";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, AssemblyJEIWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        IGuiIngredientGroup energies = recipeLayout.getIngredientsGroup(IngredientTypes.ENERGY);
        IGuiIngredientGroup lasers = recipeLayout.getIngredientsGroup(IngredientTypes.LASER);
        IGuiIngredientGroup infos = recipeLayout.getIngredientsGroup(IngredientTypes.INFO);
        int i = 0;
        int e = 0;
        int g = 0;
        int l = 0;
        int m = 0;
        recipeWrapper.recipe.generateJEI();
        for (JEISlot slot : recipeWrapper.recipe.jeiSlots) {
            if (slot instanceof ItemSlot) {
                items.init(i, slot.isInput(), (IIngredientRenderer)this.stackRenderer, slot.x * 18, slot.y * 18, GuiItemStackGroup.getWidth((int)1), GuiItemStackGroup.getHeight((int)1), 1, 1);
                items.set(i, ((ItemSlot)slot).items);
                ++i;
            }
            if (slot instanceof FluidSlot) {
                fluids.init(e, slot.isInput(), slot.x * 18 + 1, slot.y * 18 + 1, 16, 16, ((FluidSlot)slot).normalizer.get(), false, null);
                fluids.set(e, ((FluidSlot)slot).fluids);
                ++e;
            }
            if (slot instanceof EnergySlot) {
                energies.init(g, slot.isInput(), slot.x * 18 + 1, slot.y * 18 + 1);
                energies.set(g, (Object)((EnergySlot)slot).getEnergy());
                ++g;
            }
            if (slot instanceof LaserSlot) {
                lasers.init(l, slot.isInput(), slot.x * 18 + 1, slot.y * 18 + 1);
                lasers.set(l, ((LaserSlot)slot).energies);
                ++l;
            }
            if (!(slot instanceof JEIInfoSlot)) continue;
            infos.init(m, slot.isInput(), slot.x * 18 + 1, slot.y * 18 + 1);
            infos.set(m, (Object)((JEIInfoSlot)slot).info);
            ++m;
        }
    }
}

