/*
 * Decompiled with CFR 0.152.
 */
package requious.block;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import requious.block.IDynamicModel;
import requious.data.EmitterData;

public abstract class BlockEmitter
extends Block
implements IDynamicModel {
    public static final PropertyDirection facing = PropertyDirection.func_177714_a((String)"facing");
    EmitterData data;

    public BlockEmitter(Material materialIn, EmitterData data) {
        super(materialIn);
        this.data = data;
    }

    public EmitterData getData() {
        return this.data;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)facing)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)face);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        BlockPos attachPos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)facing), -1);
        IBlockState attachState = world.func_180495_p(attachPos);
        if (attachState.func_177230_c().func_176200_f((IBlockAccess)world, attachPos)) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)facing)) {
            case UP: {
                return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
            }
            case DOWN: {
                return new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
            }
            case NORTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
            }
            case WEST: {
                return new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);
            }
        }
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    @Override
    public ResourceLocation getRedirect() {
        return this.data.model;
    }

    @Override
    public Color getTint(int tintIndex) {
        return this.data.getColor(tintIndex);
    }
}

