/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.multi.TableDataSourceWorldScriptMulti;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.expression.EnvironmentExpression;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.script.WorldScript;
import ivorius.reccomplex.world.gen.script.WorldScriptRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class WorldScriptMulti
implements WorldScript<InstanceData> {
    public final List<WorldScript> scripts = new ArrayList<WorldScript>();
    public final EnvironmentExpression environmentExpression = new EnvironmentExpression();

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        InstanceData instanceData = new InstanceData();
        for (WorldScript script : this.scripts) {
            instanceData.addInstanceData(script, (NBTStorable)script.prepareInstanceData(context, pos));
        }
        instanceData.deactivated = !this.environmentExpression.test(context.environment);
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound(), this.scripts, context);
    }

    @Override
    public void generate(StructureSpawnContext context, RunTransformer transformer, InstanceData instanceData, BlockPos pos) {
        if (!instanceData.deactivated) {
            for (Pair<WorldScript, NBTStorable> paired : instanceData.pairedScripts) {
                ((WorldScript)paired.getLeft()).generate(context, transformer, (NBTStorable)paired.getRight(), pos);
            }
        }
    }

    @Override
    public String getDisplayString() {
        int amount = this.scripts.size();
        return amount == 0 ? IvTranslations.get("reccomplex.worldscript.multi.none") : IvTranslations.format("reccomplex.worldscript.multi.multiple", amount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(BlockPos realWorldPos, TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptMulti(this, realWorldPos, tableDelegate, navigator);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.scripts.clear();
        this.scripts.addAll(NBTTagLists.compoundsFrom(compound, "scripts").stream().map(WorldScriptRegistry.INSTANCE::read).filter(Objects::nonNull).collect(Collectors.toList()));
        this.environmentExpression.setExpression(compound.func_74779_i("environmentMatcher"));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeTo(compound, "scripts", this.scripts.stream().map(WorldScriptRegistry.INSTANCE::write).collect(Collectors.toList()));
        compound.func_74778_a("environmentMatcher", this.environmentExpression.getExpression());
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<Pair<WorldScript, NBTStorable>> pairedScripts = new ArrayList<Pair<WorldScript, NBTStorable>>();
        public boolean deactivated;

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound, List<WorldScript> expectedScripts, StructureLoadContext context) {
            List<NBTTagCompound> compoundsFrom = NBTTagLists.compoundsFrom(compound, "instanceDates");
            for (int i = 0; i < compoundsFrom.size(); ++i) {
                NBTTagCompound scriptTag = compoundsFrom.get(i);
                WorldScript script = expectedScripts.get(i);
                if (!WorldScriptRegistry.INSTANCE.type(script.getClass()).equals(scriptTag.func_74779_i("id"))) continue;
                this.addInstanceData(script, (NBTStorable)script.loadInstanceData(context, scriptTag.func_74781_a("data")));
            }
            this.deactivated = compound.func_74767_n("deactivated");
        }

        public void addInstanceData(WorldScript script, NBTStorable instanceData) {
            this.pairedScripts.add((Pair<WorldScript, NBTStorable>)Pair.of((Object)script, (Object)instanceData));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList dataList = new NBTTagList();
            for (int i = 0; i < this.pairedScripts.size(); ++i) {
                NBTTagCompound scriptTag = new NBTTagCompound();
                scriptTag.func_74782_a("data", ((NBTStorable)this.pairedScripts.get(i).getRight()).writeToNBT());
                scriptTag.func_74778_a("id", WorldScriptRegistry.INSTANCE.type(((WorldScript)this.pairedScripts.get(i).getLeft()).getClass()));
                dataList.func_74742_a((NBTBase)scriptTag);
            }
            nbt.func_74782_a("instanceDates", (NBTBase)dataList);
            nbt.func_74757_a("deactivated", this.deactivated);
            return nbt;
        }
    }
}

