/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.villages;

import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaGeneration;
import ivorius.reccomplex.world.gen.feature.villages.VanillaGenerationClassFactory;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class GenericVillagePiece
extends StructureVillagePieces.Village {
    public String structureID;
    public String generationID;
    public AxisAlignedTransform2D transform;
    public long seed;
    public boolean startedGeneration;
    public NBTBase instanceData;

    public GenericVillagePiece() {
    }

    public GenericVillagePiece(StructureVillagePieces.Start start, int generationDepth) {
        super(start, generationDepth);
    }

    public static AxisAlignedTransform2D getTransform(@Nonnull EnumFacing front, boolean mirrorX, @Nonnull EnumFacing toFront) {
        return AxisAlignedTransform2D.from(GenericVillagePiece.getRotations(front, mirrorX, toFront), mirrorX);
    }

    @Nullable
    public static AxisAlignedTransform2D getTransform(@Nullable EnumFacing front, boolean canMirror, boolean canRotate, EnumFacing toFront, Random random) {
        boolean mirror;
        boolean bl = mirror = canMirror && random.nextBoolean();
        AxisAlignedTransform2D transform = front != null ? GenericVillagePiece.getTransform(front, mirror, toFront) : AxisAlignedTransform2D.from(canRotate ? random.nextInt(4) : 0, mirror);
        return canRotate || transform.getRotation() == 0 ? transform : null;
    }

    public static int getRotations(EnumFacing front, boolean mirrorX, EnumFacing toFront) {
        Integer rotations = Directions.getHorizontalClockwiseRotations(front, toFront, mirrorX);
        return rotations == null ? 0 : rotations;
    }

    @Nullable
    public static GenericVillagePiece create(String structureID, String generationID) {
        return VanillaGenerationClassFactory.instance().create(structureID, generationID);
    }

    @Nullable
    public static GenericVillagePiece create(String structureID, String generationID, StructureVillagePieces.Start start, int generationDepth) {
        return VanillaGenerationClassFactory.instance().create(structureID, generationID, start, generationDepth);
    }

    public static boolean canVillageGoDeeperC(StructureBoundingBox box) {
        return GenericVillagePiece.func_74895_a((StructureBoundingBox)box);
    }

    public void setIds(String structureID, String generationID) {
        this.structureID = structureID;
        this.generationID = generationID;
    }

    public void setOrientation(EnumFacing front, AxisAlignedTransform2D transform, StructureBoundingBox boundingBox) {
        this.func_186164_a(front);
        this.transform = transform;
        this.field_74887_e = boundingBox;
    }

    @Nonnull
    private Biome biome(WorldServer world) {
        return this.startPiece != null ? this.startPiece.biome : Environment.getBiome((World)world, this.field_74887_e);
    }

    @Nonnull
    protected Environment environment(WorldServer world, GenerationType generationType) {
        return new Environment(world, this.biome(world), this.field_189928_h, generationType);
    }

    public void prepare(WorldServer world) {
        Structure structure = (Structure)StructureRegistry.INSTANCE.get(this.structureID);
        if (structure == null) {
            return;
        }
        GenerationType generationType = structure.generationType(this.generationID);
        if (!(generationType instanceof VanillaGeneration)) {
            return;
        }
        VanillaGeneration vanillaGenInfo = (VanillaGeneration)generationType;
        this.instanceData = new StructureGenerator(structure).seed(this.seed).environment(this.environment(world, generationType)).transform(this.transform).boundingBox(this.field_74887_e).instanceData().map(NBTStorable::writeToNBT).orElse(null);
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox boundingBox) {
        Structure structure = (Structure)StructureRegistry.INSTANCE.get(this.structureID);
        if (structure == null) {
            return false;
        }
        GenerationType generationType = structure.generationType(this.generationID);
        if (!(generationType instanceof VanillaGeneration)) {
            return false;
        }
        VanillaGeneration vanillaGenInfo = (VanillaGeneration)generationType;
        BlockPos structureShift = this.transform.apply(vanillaGenInfo.spawnShift, new int[]{1, 1, 1});
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, boundingBox);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b + structureShift.func_177956_o(), 0);
        }
        if (world instanceof WorldServer) {
            this.generate((WorldServer)world, boundingBox, structure, generationType);
        }
        return true;
    }

    protected <T extends NBTStorable> void generate(WorldServer world, StructureBoundingBox generationBB, Structure<T> structure, GenerationType generationType) {
        if (!this.startedGeneration) {
            this.prepare(world);
        }
        boolean firstTime = !this.startedGeneration;
        StructureGenerator.GenerationResult result = new StructureGenerator<T>(structure).environment(this.environment(world, generationType)).seed(this.seed).lowerCoord(StructureBoundingBoxes.min(this.field_74887_e)).transform(this.transform).generationBB(StructureBoundingBoxes.wholeHeightBoundingBox(world, generationBB)).generationLayer(this.field_74886_g).structureID(this.structureID).maturity(firstTime ? StructureSpawnContext.GenerateMaturity.FIRST : StructureSpawnContext.GenerateMaturity.COMPLEMENT).instanceData(this.instanceData).generate();
        if (result instanceof StructureGenerator.GenerationResult.Success.New) {
            WorldStructureGenerationData.StructureEntry sight = ((StructureGenerator.GenerationResult.Success.New)result).sight;
            sight.setPreventComplementation(true);
        }
        this.startedGeneration = true;
    }

    protected void func_143012_a(NBTTagCompound compound) {
        super.func_143012_a(compound);
        compound.func_74778_a("RcSId", this.structureID);
        compound.func_74778_a("RcGtId", this.generationID);
        RCAxisAlignedTransform.write(compound, this.transform, "RcRotation", "RcMirror");
        compound.func_74772_a("seed", this.seed);
        compound.func_74757_a("RcStartGen", this.startedGeneration);
        if (this.instanceData != null) {
            compound.func_74782_a("RcInstDat", this.instanceData);
        }
    }

    protected void func_143011_b(NBTTagCompound compound, TemplateManager manager) {
        super.func_143011_b(compound, manager);
        this.structureID = compound.func_74779_i("RcSId");
        this.generationID = compound.func_74779_i("RcGtId");
        this.seed = compound.func_74764_b("seed") ? compound.func_74763_f("seed") : new Random().nextLong();
        this.transform = RCAxisAlignedTransform.read(compound, "RcRotation", "RcMirror");
        this.startedGeneration = compound.func_74767_n("RcStartGen");
        this.instanceData = compound.func_74764_b("RcInstDat") ? compound.func_74781_a("RcInstDat") : null;
    }
}

