/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.gson.annotations.SerializedName;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTTagLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Selection
extends ArrayList<Area>
implements NBTCompoundObject {
    public final int dimensions;

    public Selection(int dimensions) {
        this.dimensions = dimensions;
    }

    public Selection(int dimensions, Collection<? extends Area> c) {
        super(c);
        this.dimensions = dimensions;
    }

    private static void mergeRooms(boolean additive, int dimIndex, int[] min, int[] max, int[] position, String id, Map<MazeRoom, String> rooms) {
        for (int i = min[dimIndex]; i <= max[dimIndex]; ++i) {
            position[dimIndex] = i;
            if (dimIndex == position.length - 1) {
                if (additive) {
                    rooms.put(new MazeRoom(position), id);
                    continue;
                }
                rooms.remove(new MazeRoom(position));
                continue;
            }
            Selection.mergeRooms(additive, dimIndex + 1, min, max, position, id, rooms);
        }
    }

    public static Selection zeroSelection(int dimensions) {
        Selection selection = new Selection(dimensions);
        selection.add(new Area(true, new int[dimensions], new int[dimensions]));
        return selection;
    }

    @Nullable
    public static List<IntegerRange> toRanges(int[] lower, int[] higher) {
        return lower != null ? IntStream.range(0, lower.length).mapToObj(i -> new IntegerRange(lower[i], higher[i])).collect(Collectors.toList()) : null;
    }

    public Map<MazeRoom, String> compile(boolean additive) {
        if (additive) {
            HashMap<MazeRoom, String> rooms = new HashMap<MazeRoom, String>();
            for (Area area : this) {
                Selection.mergeRooms(area.additive, 0, area.minCoord, area.maxCoord, (int[])area.minCoord.clone(), area.identifier, rooms);
            }
            return rooms;
        }
        HashMap<MazeRoom, String> spaces = new HashMap<MazeRoom, String>();
        int[] min = this.boundsLower();
        int[] max = this.boundsHigher();
        Selection.mergeRooms(true, 0, min, max, (int[])min.clone(), null, spaces);
        for (Area area : this) {
            Selection.mergeRooms(!area.additive, 0, area.minCoord, area.maxCoord, (int[])area.minCoord.clone(), area.identifier, spaces);
        }
        return spaces;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.clear();
        NBTTagLists.compoundsFrom(compound, "areas").forEach((? super T cmp) -> this.add(new Area((NBTTagCompound)cmp, this.dimensions)));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeTo(compound, "areas", this.stream().map(Area::writeToNBT).collect(Collectors.toList()));
    }

    @Nullable
    public List<IntegerRange> bounds() {
        return Selection.toRanges(this.boundsLower(), this.boundsHigher());
    }

    @Nullable
    public int[] boundsLower() {
        int[] min = null;
        for (Area area : this) {
            if (min == null) {
                min = (int[])area.minCoord.clone();
                continue;
            }
            for (int d = 0; d < area.minCoord.length; ++d) {
                min[d] = Math.min(min[d], area.minCoord[d]);
            }
        }
        return min;
    }

    @Nullable
    public int[] boundsHigher() {
        int[] max = null;
        for (Area area : this) {
            if (max == null) {
                max = (int[])area.maxCoord.clone();
                continue;
            }
            for (int d = 0; d < area.maxCoord.length; ++d) {
                max[d] = Math.max(max[d], area.maxCoord[d]);
            }
        }
        return max;
    }

    public int[] boundsSize() {
        int[] min = this.boundsLower();
        int[] max = this.boundsHigher();
        for (int i = 0; i < max.length; ++i) {
            int n = i;
            max[n] = max[n] + (1 - min[i]);
        }
        return max;
    }

    public Selection copy() {
        Selection selection = new Selection(this.dimensions);
        selection.addAll(this.stream().map(Area::copy).collect(Collectors.toList()));
        return selection;
    }

    public void transform(AxisAlignedTransform2D transform, int[] size, int centerCorrection) {
        this.forEach((? super E area) -> area.transform(transform, size, centerCorrection));
    }

    public static class Area {
        @SerializedName(value="additive")
        private boolean additive;
        @SerializedName(value="minCoord")
        private int[] minCoord;
        @SerializedName(value="maxCoord")
        private int[] maxCoord;
        @Nullable
        @SerializedName(value="identifier")
        private String identifier;

        public Area(boolean additive, int[] minCoord, int[] maxCoord) {
            this.additive = additive;
            this.minCoord = minCoord;
            this.maxCoord = maxCoord;
            if (minCoord.length != maxCoord.length) {
                throw new IllegalArgumentException();
            }
        }

        public Area(boolean additive, int[] minCoord, int[] maxCoord, @Nullable String identifier) {
            this.additive = additive;
            this.minCoord = minCoord;
            this.maxCoord = maxCoord;
            this.identifier = identifier;
            if (minCoord.length != maxCoord.length) {
                throw new IllegalArgumentException();
            }
        }

        public Area(NBTTagCompound tagCompound, int dimensions) {
            this.additive = tagCompound.func_74767_n("additive");
            this.minCoord = IvNBTHelper.readIntArrayFixedSize("min", dimensions, tagCompound);
            this.maxCoord = IvNBTHelper.readIntArrayFixedSize("max", dimensions, tagCompound);
            this.identifier = tagCompound.func_150297_b("identifier", 8) ? tagCompound.func_74779_i("identifier") : null;
        }

        public static Area from(boolean additive, int[] left, int[] right, @Nullable String identifier) {
            int[] min = new int[left.length];
            int[] max = new int[right.length];
            for (int i = 0; i < left.length; ++i) {
                min[i] = Math.min(left[i], right[i]);
                max[i] = Math.max(left[i], right[i]);
            }
            return new Area(additive, min, max, identifier);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("additive", this.additive);
            compound.func_74783_a("min", this.minCoord);
            compound.func_74783_a("max", this.maxCoord);
            if (this.identifier != null) {
                compound.func_74778_a("identifier", this.identifier);
            }
            return compound;
        }

        public int[] getMinCoord() {
            return (int[])this.minCoord.clone();
        }

        public void setMinCoord(int[] minCoord) {
            this.minCoord = (int[])minCoord.clone();
        }

        public int[] getMaxCoord() {
            return (int[])this.maxCoord.clone();
        }

        public void setMaxCoord(int[] maxCoord) {
            this.maxCoord = (int[])maxCoord.clone();
        }

        public void setCoord(int dim, int min, int max) {
            this.minCoord[dim] = min;
            this.maxCoord[dim] = max;
        }

        public boolean isAdditive() {
            return this.additive;
        }

        public void setAdditive(boolean additive) {
            this.additive = additive;
        }

        @Nullable
        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(@Nullable String identifier) {
            this.identifier = identifier;
        }

        public Area copy() {
            return new Area(this.additive, (int[])this.minCoord.clone(), (int[])this.maxCoord.clone(), this.identifier);
        }

        public void transform(AxisAlignedTransform2D transform, int[] size, int centerCorrection) {
            transform.applyOn(this.minCoord, size, centerCorrection);
            transform.applyOn(this.maxCoord, size, centerCorrection);
            for (int i = 0; i < this.minCoord.length; ++i) {
                int min = Math.min(this.minCoord[i], this.maxCoord[i]);
                int max = Math.max(this.minCoord[i], this.maxCoord[i]);
                this.minCoord[i] = min;
                this.maxCoord[i] = max;
            }
        }

        public boolean includes(Area area) {
            for (int i = 0; i < this.minCoord.length; ++i) {
                if (this.minCoord[i] <= area.minCoord[i] && this.maxCoord[i] >= area.maxCoord[i]) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public Area intersection(Area area) {
            if (area.minCoord.length != this.minCoord.length) {
                throw new IllegalArgumentException();
            }
            int[] min = new int[this.minCoord.length];
            int[] max = new int[this.minCoord.length];
            for (int i = 0; i < min.length; ++i) {
                min[i] = Math.max(min[i], area.minCoord[i]);
                max[i] = Math.min(max[i], area.maxCoord[i]);
                if (min[i] <= max[i]) continue;
                return null;
            }
            return new Area(this.additive, min, max);
        }
    }
}

