/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.tokenizer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.LineReader;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.random.Poem;
import ivorius.reccomplex.utils.PassLimiter;
import ivorius.reccomplex.utils.tokenizer.SymbolTokenizer;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TokenReplacer {
    public static final int MAX_EXPLODES = 1000;

    public static <T> String evaluate(Random random, List<Token> text, T context, Poem.StitchedTheme theme) throws OverpoemedException {
        Token token;
        StringBuilder builder = new StringBuilder();
        PassLimiter<OverpoemedException> limiter = new PassLimiter<OverpoemedException>(OverpoemedException::new, 1000);
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        queue.addAll(text);
        HashMap<String, List<Token>> repeats = new HashMap<String, List<Token>>();
        boolean nextUpper = true;
        while ((token = (Token)queue.poll()) != null) {
            if (token instanceof ExplodingToken) {
                List<Token> addTokens;
                ExplodingToken symbol = (ExplodingToken)token;
                boolean remember = symbol.flags.contains("rem");
                boolean repeat = symbol.flags.contains("rep");
                List<Token> list = addTokens = repeat ? (List<Token>)repeats.get(symbol.tag) : symbol.explode(theme, context, random);
                if (repeat && addTokens == null) {
                    addTokens = Collections.singletonList(new StringToken(symbol.startIndex, symbol.endIndex, "EMPTY_REPEAT"));
                }
                if (remember) {
                    repeats.put(symbol.tag, addTokens);
                }
                for (int i = addTokens.size() - 1; i >= 0; --i) {
                    queue.addFirst(addTokens.get(i));
                }
                limiter.add(addTokens.size());
                continue;
            }
            if (!(token instanceof StringToken)) continue;
            String string = ((StringToken)token).string;
            builder.append(nextUpper ? TokenReplacer.firstCharUppercase(string) : string);
            nextUpper = string.matches(".*[.?!]$");
        }
        return builder.toString();
    }

    public static String firstCharUppercase(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static class OverpoemedException
    extends Exception {
    }

    public static abstract class Theme {
        public Multimap<String, String> contents = HashMultimap.create();

        public static String parameter(List<String> flags, int index, String def) {
            return flags.size() > index ? flags.get(index) : def;
        }

        protected void read(String fileContents) {
            LineReader reader = new LineReader((Readable)new StringReader(fileContents));
            Collection currentList = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("***")) {
                        String tag = line.substring(4).trim();
                        currentList = this.contents.get((Object)tag);
                        continue;
                    }
                    String word = line.trim();
                    if (word.length() <= 0 || currentList == null) continue;
                    currentList.add(word);
                }
            }
            catch (IOException e) {
                RecurrentComplex.logger.error((Object)e);
            }
        }

        public Multimap<String, List<Token>> build(Multimap<String, List<Token>> map, SymbolTokenizer<Token> tokenizer) {
            for (String include : this.contents.get((Object)"include")) {
                Theme theme = this.getOther(include);
                if (theme == null) {
                    RecurrentComplex.logger.error("Can't find theme to include: " + include);
                    continue;
                }
                theme.build(map, tokenizer);
            }
            for (String key : this.contents.keySet()) {
                map.putAll((Object)key, this.contents.get((Object)key).stream().map(s -> {
                    try {
                        return tokenizer.tokenize((String)s);
                    }
                    catch (ParseException e) {
                        RecurrentComplex.logger.warn("Unable to read line: " + s, (Throwable)e);
                        return Collections.emptyList();
                    }
                })::iterator);
            }
            return map;
        }

        protected abstract Theme getOther(String var1);
    }

    public static abstract class ReplaceFactory<T>
    implements SymbolTokenizer.TokenFactory {
        public static String join(Collection<List<Token>> lists) {
            return lists.stream().map(Object::toString).reduce("", (s, r) -> s + " " + r);
        }

        @Nullable
        public SymbolTokenizer.Token tryConstructSymbolTokenAt(int index, @Nonnull String string) {
            ArrayList flags;
            int end;
            String contents;
            List<String> parts;
            String tag;
            Exploder<T> exploder;
            if (string.charAt(index) == '<' && (exploder = this.exploder(tag = (parts = Arrays.asList((contents = string.substring(index + 1, end = string.indexOf(62, index))).split(" "))).get(0), flags = Lists.newArrayList(parts.subList(1, parts.size())))) != null) {
                return new ExplodingToken<T>(index, end + 1, tag, flags, exploder);
            }
            return null;
        }

        protected abstract Exploder<T> exploder(String var1, List<String> var2);

        @Nonnull
        public SymbolTokenizer.Token constructStringToken(int index, @Nonnull String string) {
            return new StringToken(index, index + string.length(), string);
        }
    }

    public static class StringToken
    extends Token {
        public String string;

        public StringToken(int startIndex, int endIndex, String string) {
            super(startIndex, endIndex);
            this.string = string;
        }
    }

    public static class ExplodingToken<T>
    extends Token {
        public final String tag;
        public final List<String> flags;
        public final Exploder<T> exploder;

        public ExplodingToken(int startIndex, int endIndex, String tag, List<String> flags, Exploder<T> exploder) {
            super(startIndex, endIndex);
            this.tag = tag;
            this.flags = flags;
            this.exploder = exploder;
        }

        public List<Token> explode(Poem.StitchedTheme theme, T context, Random random) {
            return this.exploder.explode(this, theme, context, random);
        }
    }

    public static abstract class Token
    extends SymbolTokenizer.Token {
        public Token(int startIndex, int endIndex) {
            super(startIndex, endIndex);
        }
    }

    public static interface Exploder<T> {
        public static <T> Exploder<T> string(StringExploder<T> exploder) {
            return (token, theme, context, random) -> Collections.singletonList(new StringToken(0, 0, exploder.evaluate(token, theme, context, random)));
        }

        public List<Token> explode(ExplodingToken var1, Poem.StitchedTheme var2, T var3, Random var4);

        public static interface StringExploder<T> {
            public String evaluate(ExplodingToken var1, Poem.StitchedTheme var2, T var3, Random var4);
        }
    }
}

