/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import java.text.ParseException;
import java.util.function.Function;
import net.minecraft.util.text.TextFormatting;

public class GenerationTypeExpression
extends BoolFunctionExpressionCache<GenerationType, Object> {
    public static final String ID_PREFIX = "id=";
    public static final String TYPE_PREFIX = "type=";

    public GenerationTypeExpression() {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Any Generation");
        this.addTypes(new IdentifierType(ID_PREFIX, ""), new Function[0]);
        this.addTypes(new TypeType(TYPE_PREFIX, ""), t -> t.alias("$", ""));
    }

    protected static class TypeType
    extends FunctionExpressionCache.VariableType<Boolean, GenerationType, Object> {
        public TypeType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<GenerationType>, Boolean> parse(String var) throws ParseException {
            Class<GenerationType> theClass = StructureRegistry.GENERATION_TYPES.typeForID(var);
            return theClass != null ? info -> info.get() != null && theClass.isAssignableFrom(((GenerationType)info.get()).getClass()) : info -> false;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object args) {
            return StructureRegistry.GENERATION_TYPES.typeForID(var) != null ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }

    protected static class IdentifierType
    extends FunctionExpressionCache.VariableType<Boolean, GenerationType, Object> {
        public IdentifierType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<GenerationType>, Boolean> parse(String var) throws ParseException {
            return info -> info.get() != null && var.equals(((GenerationType)info.get()).id());
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object args) {
            return FunctionExpressionCache.Validity.KNOWN;
        }
    }
}

