/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.reccomplex.utils.RCBlockAreas;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class RCStructureBoundingBoxes {
    public static Set<ChunkPos> rasterize(StructureBoundingBox boundingBox, boolean decorate) {
        if (!RCStructureBoundingBoxes.valid(boundingBox)) {
            return Collections.emptySet();
        }
        int shift = decorate ? 8 : 0;
        int minX = boundingBox.field_78897_a - shift >> 4;
        int maxX = boundingBox.field_78893_d - shift >> 4;
        int minZ = boundingBox.field_78896_c - shift >> 4;
        int maxZ = boundingBox.field_78892_f - shift >> 4;
        HashSet<ChunkPos> pairs = new HashSet<ChunkPos>((maxX - minX + 1) * (maxZ - minZ + 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                pairs.add(new ChunkPos(x, z));
            }
        }
        return pairs;
    }

    public static boolean valid(StructureBoundingBox boundingBox) {
        return boundingBox != null && boundingBox.field_78897_a <= boundingBox.field_78893_d && boundingBox.field_78895_b <= boundingBox.field_78894_e && boundingBox.field_78896_c <= boundingBox.field_78892_f;
    }

    public static StructureBoundingBox expand(StructureBoundingBox box, int x, int y, int z) {
        box.field_78897_a -= x;
        box.field_78895_b -= y;
        box.field_78896_c -= z;
        box.field_78893_d += x;
        box.field_78894_e += y;
        box.field_78892_f += z;
        return box;
    }

    public static StructureBoundingBox offset(StructureBoundingBox box, int x, int y, int z) {
        box.func_78886_a(x, y, z);
        return box;
    }

    @Nonnull
    public static BlockPos getCenter(StructureBoundingBox boundingBox) {
        return new BlockPos((boundingBox.field_78897_a + boundingBox.field_78893_d) / 2, (boundingBox.field_78895_b + boundingBox.field_78894_e) / 2, (boundingBox.field_78896_c + boundingBox.field_78892_f) / 2);
    }

    @Nullable
    public static StructureBoundingBox intersection(StructureBoundingBox left, StructureBoundingBox right) {
        if (!left.func_78884_a(right)) {
            return null;
        }
        return new StructureBoundingBox(Math.max(left.field_78897_a, right.field_78897_a), Math.max(left.field_78895_b, right.field_78895_b), Math.max(left.field_78896_c, right.field_78896_c), Math.min(left.field_78893_d, right.field_78893_d), Math.min(left.field_78894_e, right.field_78894_e), Math.min(left.field_78892_f, right.field_78892_f));
    }

    @Nonnull
    public static Iterable<BlockPos> positions(@Nonnull StructureBoundingBox area) {
        return BlockAreas.positions(RCBlockAreas.from(area));
    }

    @Nonnull
    public static Iterable<BlockPos.MutableBlockPos> mutablePositions(@Nonnull StructureBoundingBox area) {
        return BlockAreas.mutablePositions(RCBlockAreas.from(area));
    }

    @Nonnull
    public static Stream<BlockPos> streamPositions(@Nonnull StructureBoundingBox area) {
        return BlockAreas.streamPositions(RCBlockAreas.from(area));
    }

    @Nonnull
    public static Stream<BlockPos.MutableBlockPos> streamMutablePositions(@Nonnull StructureBoundingBox area) {
        return BlockAreas.streamMutablePositions(RCBlockAreas.from(area));
    }
}

