/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.maze;

import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MazeInterpreter {
    public static <C> void print2D(MazeComponent<C> component, MazePredicate<C> predicate, MazeRoom ... mark) {
        MazeInterpreter.print2D(component, predicate, (MazeRoom r) -> Arrays.asList(mark).contains(r) ? "O" : null);
    }

    public static <C> void print2D(MazeComponent<C> component, MazePredicate<C> predicate, Function<MazeRoom, String> marker) {
        int minY = component.rooms().stream().mapToInt(r -> r.getCoordinate(1)).min().orElseThrow(IllegalArgumentException::new);
        int maxY = component.rooms().stream().mapToInt(r -> r.getCoordinate(1)).max().orElseThrow(IllegalArgumentException::new);
        int y = minY;
        while (y <= maxY) {
            System.out.print(MazeInterpreter.toString(component, predicate, 0, 2, new MazeRoom(0, y++, 0), marker));
        }
    }

    public static <C> String toString(MazeComponent<C> component, @Nullable MazePredicate<C> predicate, int xDim, int zDim, MazeRoom pos, @Nullable Function<MazeRoom, String> marker) {
        int minX = component.rooms().stream().mapToInt(r -> r.getCoordinate(xDim)).min().orElseThrow(IllegalArgumentException::new) - 1;
        int minZ = component.rooms().stream().mapToInt(r -> r.getCoordinate(zDim)).min().orElseThrow(IllegalArgumentException::new) - 1;
        int maxX = component.rooms().stream().mapToInt(r -> r.getCoordinate(xDim)).max().orElseThrow(IllegalArgumentException::new) + 1;
        int maxZ = component.rooms().stream().mapToInt(r -> r.getCoordinate(zDim)).max().orElseThrow(IllegalArgumentException::new) + 1;
        StringBuilder builder = new StringBuilder();
        builder.append(" ");
        for (int x = minX; x <= maxX; ++x) {
            builder.append((x % 10 + 10) % 10).append(" ");
        }
        builder.append("\n");
        for (int z = minZ; z <= maxZ; ++z) {
            MazeRoom mazeRoom;
            int x;
            builder.append((z % 10 + 10) % 10);
            for (x = minX; x <= maxX; ++x) {
                String marked;
                mazeRoom = MazeInterpreter.setInDimension(MazeInterpreter.setInDimension(pos, zDim, z), xDim, x);
                String string = marked = marker != null ? marker.apply(mazeRoom) : null;
                String rep = marked != null ? marked : (component.rooms().contains(mazeRoom) ? "X" : " ");
                MazeRoom next = mazeRoom.addInDimension(xDim, 1);
                if (x < maxX && MazeInterpreter.isConnection(component, new MazeRoomConnection(mazeRoom, next))) {
                    builder.append(rep).append("-");
                    continue;
                }
                builder.append(rep).append(" ");
            }
            if (z < maxZ) {
                builder.append("\n ");
                for (x = minX; x <= maxX; ++x) {
                    mazeRoom = MazeInterpreter.setInDimension(MazeInterpreter.setInDimension(pos, zDim, z), xDim, x);
                    MazeRoom next = mazeRoom.addInDimension(zDim, 1);
                    String rep = " ";
                    if (MazeInterpreter.isConnection(component, new MazeRoomConnection(mazeRoom, next))) {
                        rep = "|";
                    }
                    builder.append(rep).append(" ");
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    protected static <C> boolean isExit(MazeComponent<C> component, @Nullable MazePredicate<C> predicate, MazeRoom mazeRoom) {
        return component.exits().keySet().stream().filter(p -> p.getDest().equals(mazeRoom) || p.getSource().equals(mazeRoom)).anyMatch(p -> predicate != null && predicate.isDirtyConnection(p.getSource(), p.getDest(), component.exits().get(p)));
    }

    protected static <C> boolean isConnection(MazeComponent<C> component, MazeRoomConnection connection) {
        MazePassage fst = new MazePassage(connection.getLeft(), connection.getRight());
        MazePassage sec = new MazePassage(connection.getRight(), connection.getLeft());
        return component.reachability().get((Object)fst).contains((Object)sec) || component.reachability().get((Object)sec).contains((Object)fst);
    }

    protected static MazeRoom setInDimension(MazeRoom pos, int dim, int val) {
        return pos.addInDimension(dim, val - pos.getCoordinate(dim));
    }
}

