/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import ivorius.reccomplex.RecurrentComplex;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class RCFiles {
    public static String encodePath(String path) {
        return path.replaceAll(" ", "%20");
    }

    public static void closeQuietly(FileSystem fileSystem) {
        if (fileSystem != FileSystems.getDefault()) {
            try {
                fileSystem.close();
            }
            catch (IOException | ClosedFileSystemException exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Path path) {
        if (path != null) {
            RCFiles.closeQuietly(path.getFileSystem());
        }
    }

    static Path resourceToPath(URL resource) throws IOException, URISyntaxException {
        FileSystem fs2;
        Objects.requireNonNull(resource, "Resource URL cannot be null");
        URI uri = resource.toURI();
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        if (!scheme.equals("jar")) {
            throw new IllegalArgumentException("Cannot convert to Path: " + uri);
        }
        String s = RCFiles.encodePath(uri.toString());
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        try {
            fs2 = FileSystems.getFileSystem(fileURI);
            if (fs2.isOpen()) {
                return fs2.getPath(entryName, new String[0]);
            }
        }
        catch (FileSystemNotFoundException fs2) {
            // empty catch block
        }
        fs2 = FileSystems.newFileSystem(fileURI, Collections.emptyMap());
        return fs2.getPath(entryName, new String[0]);
    }

    @Nullable
    public static Path pathFromResourceLocation(ResourceLocation resourceLocation) throws ResourceLocationLoadException {
        try {
            URL resource = RCFiles.class.getResource(String.format("/assets/%s%s", resourceLocation.func_110624_b(), resourceLocation.func_110623_a().isEmpty() ? "" : "/" + resourceLocation.func_110623_a()));
            return resource != null ? RCFiles.resourceToPath(resource.toURI().toURL()) : null;
        }
        catch (Exception e) {
            throw new ResourceLocationLoadException(e, resourceLocation);
        }
    }

    @Nullable
    public static Path tryPathFromResourceLocation(ResourceLocation resourceLocation) {
        try {
            return RCFiles.pathFromResourceLocation(resourceLocation);
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error reading from resource location '" + resourceLocation + "'", e);
            return null;
        }
    }

    public static void walkFilesRecursively(Path dir, final DirectoryStream.Filter<Path> filter, final boolean recursive, final Consumer<Path> consumer) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (filter.accept(file)) {
                        consumer.accept(file);
                    }
                    return recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException e) {
            RecurrentComplex.logger.error((Object)e);
        }
    }

    public static List<Path> listFilesRecursively(Path dir, DirectoryStream.Filter<Path> filter, boolean recursive) {
        ArrayList<Path> list = new ArrayList<Path>();
        RCFiles.walkFilesRecursively(dir, filter, recursive, list::add);
        return list;
    }

    public static boolean ensure(File file) {
        if (!file.exists() && !file.mkdir()) {
            System.out.println("Could not create " + file.getName() + " folder");
            return false;
        }
        return true;
    }

    public static File getValidatedFolder(File file, boolean create) {
        return (create ? RCFiles.ensure(file) : file.exists()) ? file : null;
    }

    @Nullable
    public static String extension(Path path) {
        return FilenameUtils.getExtension((String)path.getFileName().toString());
    }

    public static Path filenamePath(String name, String extension) {
        return Paths.get(name + "." + extension, new String[0]);
    }

    public static class ResourceLocationLoadException
    extends Exception {
        public final ResourceLocation location;

        public ResourceLocationLoadException(ResourceLocation location) {
            this.location = location;
        }

        public ResourceLocationLoadException(String message, ResourceLocation location) {
            super(message);
            this.location = location;
        }

        public ResourceLocationLoadException(String message, Throwable cause, ResourceLocation location) {
            super(message, cause);
            this.location = location;
        }

        public ResourceLocationLoadException(Throwable cause, ResourceLocation location) {
            super(cause);
            this.location = location;
        }

        public ResourceLocationLoadException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, ResourceLocation location) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.location = location;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }
    }
}

