/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class AxisAlignedTransform2D {
    public static final AxisAlignedTransform2D R0 = new AxisAlignedTransform2D(0, false);
    public static final AxisAlignedTransform2D R1 = new AxisAlignedTransform2D(1, false);
    public static final AxisAlignedTransform2D R2 = new AxisAlignedTransform2D(2, false);
    public static final AxisAlignedTransform2D R3 = new AxisAlignedTransform2D(3, false);
    public static final AxisAlignedTransform2D R0_F = new AxisAlignedTransform2D(0, true);
    public static final AxisAlignedTransform2D R1_F = new AxisAlignedTransform2D(1, true);
    public static final AxisAlignedTransform2D R2_F = new AxisAlignedTransform2D(2, true);
    public static final AxisAlignedTransform2D R3_F = new AxisAlignedTransform2D(3, true);
    public static final AxisAlignedTransform2D ORIGINAL = R0;
    private final int rotation;
    private final boolean mirrorX;

    @Deprecated
    public AxisAlignedTransform2D(int rotationClockwise, boolean mirrorX) {
        this.rotation = (rotationClockwise % 4 + 4) % 4;
        this.mirrorX = mirrorX;
    }

    @Deprecated
    public static AxisAlignedTransform2D transform(int rotationClockwise, boolean flipX) {
        return AxisAlignedTransform2D.from(rotationClockwise, flipX);
    }

    public static AxisAlignedTransform2D from(int rotationClockwise, boolean flipX) {
        switch ((rotationClockwise % 4 + 4) % 4) {
            case 0: {
                return flipX ? R0_F : R0;
            }
            case 1: {
                return flipX ? R1_F : R1;
            }
            case 2: {
                return flipX ? R2_F : R2;
            }
            case 3: {
                return flipX ? R3_F : R3;
            }
        }
        throw new InternalError();
    }

    public static AxisAlignedTransform2D transform(AxisAlignedTransform2D original, int rotationClockwise, boolean flipX) {
        return flipX ? original.rotateClockwise(rotationClockwise).flipX() : original.rotateClockwise(rotationClockwise);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isMirrorX() {
        return this.mirrorX;
    }

    public AxisAlignedTransform2D rotateClockwise(int steps) {
        return AxisAlignedTransform2D.from(this.rotation + steps, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateClockwise() {
        return AxisAlignedTransform2D.from(this.rotation + 1, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise(int steps) {
        return AxisAlignedTransform2D.from(this.rotation - steps, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise() {
        return AxisAlignedTransform2D.from(this.rotation - 1, this.mirrorX);
    }

    public AxisAlignedTransform2D flipX() {
        return AxisAlignedTransform2D.from(this.rotation, !this.mirrorX);
    }

    public AxisAlignedTransform2D flipZ() {
        return AxisAlignedTransform2D.from(this.rotation + 2, !this.mirrorX);
    }

    public boolean resultSwitchesXZ() {
        return this.rotation == 1 || this.rotation == 3;
    }

    public boolean resultMirrorsFormerX() {
        return this.mirrorX ^ (this.rotation == 2 || this.rotation == 3);
    }

    public boolean resultMirrorsFormerZ() {
        return this.rotation == 1 || this.rotation == 2;
    }

    public int apply(int direction) {
        if (direction < 0 || direction > 3) {
            throw new IllegalArgumentException();
        }
        boolean mirrorApplies = this.mirrorX && this.rotation % 2 == 1;
        return (direction + this.rotation + (mirrorApplies ? 2 : 0)) % 4;
    }

    public EnumFacing apply(EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return facing;
        }
        if (this.mirrorX && facing.func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        return EnumFacing.field_176754_o[(facing.func_176736_b() + this.rotation) % EnumFacing.field_176754_o.length];
    }

    public BlockPos.MutableBlockPos applyOn(BlockPos.MutableBlockPos position, int[] size) {
        return this.applyOn((BlockPos)position, position, size, 1);
    }

    public BlockPos.MutableBlockPos applyOn(BlockPos.MutableBlockPos position, int[] size, int centerCorrection) {
        return this.applyOn((BlockPos)position, position, size, centerCorrection);
    }

    public BlockPos.MutableBlockPos applyOn(BlockPos position, BlockPos.MutableBlockPos onPosition, int[] size) {
        return this.applyOn(position, onPosition, size, 1);
    }

    public BlockPos.MutableBlockPos applyOn(BlockPos position, BlockPos.MutableBlockPos onPosition, int[] size, int centerCorrection) {
        int positionX = this.mirrorX ? size[0] - centerCorrection - position.func_177958_n() : position.func_177958_n();
        switch (this.rotation) {
            case 0: {
                return onPosition.func_181079_c(positionX, position.func_177956_o(), position.func_177952_p());
            }
            case 1: {
                return onPosition.func_181079_c(size[2] - centerCorrection - position.func_177952_p(), position.func_177956_o(), positionX);
            }
            case 2: {
                return onPosition.func_181079_c(size[0] - centerCorrection - positionX, position.func_177956_o(), size[2] - centerCorrection - position.func_177952_p());
            }
            case 3: {
                return onPosition.func_181079_c(position.func_177952_p(), position.func_177956_o(), size[0] - centerCorrection - positionX);
            }
        }
        throw new InternalError();
    }

    public BlockPos apply(BlockPos position, int[] size) {
        return this.apply(position, size, 1);
    }

    public BlockPos apply(BlockPos position, int[] size, int centerCorrection) {
        int positionX = this.mirrorX ? size[0] - centerCorrection - position.func_177958_n() : position.func_177958_n();
        switch (this.rotation) {
            case 0: {
                return new BlockPos(positionX, position.func_177956_o(), position.func_177952_p());
            }
            case 1: {
                return new BlockPos(size[2] - centerCorrection - position.func_177952_p(), position.func_177956_o(), positionX);
            }
            case 2: {
                return new BlockPos(size[0] - centerCorrection - positionX, position.func_177956_o(), size[2] - centerCorrection - position.func_177952_p());
            }
            case 3: {
                return new BlockPos(position.func_177952_p(), position.func_177956_o(), size[0] - centerCorrection - positionX);
            }
        }
        throw new InternalError();
    }

    public double[] apply(double[] position, int[] size) {
        return this.applyOn(position, new double[position.length], size, 0);
    }

    public double[] applyOn(double[] position, int[] size) {
        return this.applyOn(position, position, size, 0);
    }

    public double[] applyOn(double[] position, int[] size, int centerCorrection) {
        return this.applyOn(position, position, size, centerCorrection);
    }

    public double[] applyOn(double[] position, double[] on, int[] size, int centerCorrection) {
        double z;
        double x;
        double positionX = this.mirrorX ? (double)(size[0] - centerCorrection) - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                x = positionX;
                z = position[2];
                break;
            }
            case 1: {
                x = (double)(size[2] - centerCorrection) - position[2];
                z = positionX;
                break;
            }
            case 2: {
                x = (double)(size[0] - centerCorrection) - positionX;
                z = (double)(size[2] - centerCorrection) - position[2];
                break;
            }
            case 3: {
                x = position[2];
                z = (double)(size[0] - centerCorrection) - positionX;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        on[0] = x;
        on[1] = position[1];
        on[2] = z;
        return on;
    }

    public float[] apply(float[] position, int[] size) {
        return this.applyOn(position, new float[position.length], size, 0);
    }

    public float[] applyOn(float[] position, int[] size) {
        return this.applyOn(position, position, size, 0);
    }

    public float[] applyOn(float[] position, int[] size, int centerCorrection) {
        return this.applyOn(position, position, size, centerCorrection);
    }

    public float[] applyOn(float[] position, float[] on, int[] size, int centerCorrection) {
        float z;
        float x;
        float positionX = this.mirrorX ? (float)(size[0] - centerCorrection) - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                x = positionX;
                z = position[2];
                break;
            }
            case 1: {
                x = (float)(size[2] - centerCorrection) - position[2];
                z = positionX;
                break;
            }
            case 2: {
                x = (float)(size[0] - centerCorrection) - positionX;
                z = (float)(size[2] - centerCorrection) - position[2];
                break;
            }
            case 3: {
                x = position[2];
                z = (float)(size[0] - centerCorrection) - positionX;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        on[0] = x;
        on[1] = position[1];
        on[2] = z;
        return on;
    }

    @Deprecated
    public int[] apply(int[] position, int[] size) {
        return this.applyOn(position, new int[position.length], size, 1);
    }

    public int[] applyOn(int[] position, int[] size) {
        return this.applyOn(position, position, size, 0);
    }

    public int[] applyOn(int[] position, int[] size, int centerCorrection) {
        return this.applyOn(position, position, size, centerCorrection);
    }

    public int[] applyOn(int[] position, int[] on, int[] size, int centerCorrection) {
        int z;
        int x;
        int positionX = this.mirrorX ? size[0] - centerCorrection - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                x = positionX;
                z = position[2];
                break;
            }
            case 1: {
                x = size[2] - centerCorrection - position[2];
                z = positionX;
                break;
            }
            case 2: {
                x = size[0] - centerCorrection - positionX;
                z = size[2] - centerCorrection - position[2];
                break;
            }
            case 3: {
                x = position[2];
                z = size[0] - centerCorrection - positionX;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        on[0] = x;
        on[1] = position[1];
        on[2] = z;
        return on;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisAlignedTransform2D that = (AxisAlignedTransform2D)o;
        if (this.rotation != that.rotation) {
            return false;
        }
        return this.mirrorX == that.mirrorX;
    }

    public int hashCode() {
        int result = this.rotation;
        result = 31 * result + (this.mirrorX ? 1 : 0);
        return result;
    }

    public String toString() {
        return "AxisAlignedTransform2D{rotation=" + this.rotation + ", mirrorX=" + this.mirrorX + '}';
    }
}

