/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.gui.IntegerRange;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class BlockAreas {
    public static int sideLength(BlockArea area, EnumFacing side) {
        int[] size = area.areaSize();
        switch (side) {
            case EAST: 
            case WEST: {
                return size[0];
            }
            case UP: 
            case DOWN: {
                return size[1];
            }
            case NORTH: 
            case SOUTH: {
                return size[2];
            }
        }
        throw new IllegalArgumentException();
    }

    public static BlockArea side(BlockArea area, EnumFacing side) {
        BlockPos lowerCorner = area.getLowerCorner();
        BlockPos higherCorner = area.getHigherCorner();
        switch (side) {
            case UP: {
                return new BlockArea(new BlockPos(lowerCorner.func_177958_n(), higherCorner.func_177956_o(), lowerCorner.func_177952_p()), higherCorner);
            }
            case DOWN: {
                return new BlockArea(lowerCorner, new BlockPos(higherCorner.func_177958_n(), lowerCorner.func_177956_o(), higherCorner.func_177952_p()));
            }
            case NORTH: {
                return new BlockArea(lowerCorner, new BlockPos(higherCorner.func_177958_n(), higherCorner.func_177956_o(), lowerCorner.func_177952_p()));
            }
            case EAST: {
                return new BlockArea(new BlockPos(higherCorner.func_177958_n(), lowerCorner.func_177956_o(), lowerCorner.func_177952_p()), higherCorner);
            }
            case SOUTH: {
                return new BlockArea(new BlockPos(lowerCorner.func_177958_n(), lowerCorner.func_177956_o(), higherCorner.func_177952_p()), higherCorner);
            }
            case WEST: {
                return new BlockArea(lowerCorner, new BlockPos(lowerCorner.func_177958_n(), higherCorner.func_177956_o(), higherCorner.func_177952_p()));
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static BlockArea shrink(BlockArea area, EnumFacing side, int amount) {
        switch (side) {
            case UP: {
                return BlockAreas.shrink(area, BlockPos.field_177992_a, new BlockPos(0, amount, 0));
            }
            case DOWN: {
                return BlockAreas.shrink(area, new BlockPos(0, amount, 0), BlockPos.field_177992_a);
            }
            case NORTH: {
                return BlockAreas.shrink(area, new BlockPos(0, 0, amount), BlockPos.field_177992_a);
            }
            case EAST: {
                return BlockAreas.shrink(area, BlockPos.field_177992_a, new BlockPos(amount, 0, 0));
            }
            case SOUTH: {
                return BlockAreas.shrink(area, BlockPos.field_177992_a, new BlockPos(0, 0, amount));
            }
            case WEST: {
                return BlockAreas.shrink(area, new BlockPos(amount, 0, 0), BlockPos.field_177992_a);
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static BlockArea shrink(BlockArea area, BlockPos lower, BlockPos higher) {
        BlockPos p1 = area.getPoint1();
        BlockPos p2 = area.getPoint2();
        IntegerRange x = BlockAreas.shrink(p1.func_177958_n(), p2.func_177958_n(), lower.func_177958_n(), higher.func_177958_n());
        IntegerRange y = BlockAreas.shrink(p1.func_177956_o(), p2.func_177956_o(), lower.func_177956_o(), higher.func_177956_o());
        IntegerRange z = BlockAreas.shrink(p1.func_177952_p(), p2.func_177952_p(), lower.func_177952_p(), higher.func_177952_p());
        return x != null && y != null && z != null ? new BlockArea(new BlockPos(x.min, y.min, z.min), new BlockPos(x.max, y.max, z.max)) : null;
    }

    @Nullable
    private static IntegerRange shrink(int l, int r, int shrMin, int shrMax) {
        boolean c;
        boolean bl = c = l < r;
        return Math.abs(l - r) >= shrMin + shrMax ? new IntegerRange(c ? l + shrMin : l - shrMax, c ? r - shrMax : r + shrMin) : null;
    }

    @Nonnull
    public static BlockArea expand(BlockArea area, BlockPos lower, BlockPos higher) {
        BlockPos p1 = area.getPoint1();
        BlockPos p2 = area.getPoint2();
        IntegerRange x = BlockAreas.expand(p1.func_177958_n(), p2.func_177958_n(), lower.func_177958_n(), higher.func_177958_n());
        IntegerRange y = BlockAreas.expand(p1.func_177956_o(), p2.func_177956_o(), lower.func_177956_o(), higher.func_177956_o());
        IntegerRange z = BlockAreas.expand(p1.func_177952_p(), p2.func_177952_p(), lower.func_177952_p(), higher.func_177952_p());
        return new BlockArea(new BlockPos(x.min, y.min, z.min), new BlockPos(x.max, y.max, z.max));
    }

    @Nonnull
    private static IntegerRange expand(int l, int r, int expMin, int expMax) {
        boolean c = l < r;
        return new IntegerRange(c ? l - expMin : l + expMax, c ? r + expMax : r - expMin);
    }

    @Nonnull
    public static BlockArea expand(BlockArea area, EnumFacing side, int amount) {
        switch (side) {
            case UP: {
                return BlockAreas.expand(area, BlockPos.field_177992_a, new BlockPos(0, amount, 0));
            }
            case DOWN: {
                return BlockAreas.expand(area, new BlockPos(0, amount, 0), BlockPos.field_177992_a);
            }
            case NORTH: {
                return BlockAreas.expand(area, new BlockPos(0, 0, amount), BlockPos.field_177992_a);
            }
            case EAST: {
                return BlockAreas.expand(area, BlockPos.field_177992_a, new BlockPos(amount, 0, 0));
            }
            case SOUTH: {
                return BlockAreas.expand(area, BlockPos.field_177992_a, new BlockPos(0, 0, amount));
            }
            case WEST: {
                return BlockAreas.expand(area, new BlockPos(amount, 0, 0), BlockPos.field_177992_a);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Iterable<BlockPos> positions(BlockArea area) {
        return BlockPos.func_177980_a((BlockPos)area.getPoint1(), (BlockPos)area.getPoint2());
    }

    public static Iterable<BlockPos.MutableBlockPos> mutablePositions(BlockArea area) {
        return BlockPos.func_177975_b((BlockPos)area.getPoint1(), (BlockPos)area.getPoint2());
    }

    public static Stream<BlockPos> streamPositions(BlockArea area) {
        return StreamSupport.stream(BlockPos.func_177980_a((BlockPos)area.getPoint1(), (BlockPos)area.getPoint2()).spliterator(), false);
    }

    public static Stream<BlockPos.MutableBlockPos> streamMutablePositions(BlockArea area) {
        return StreamSupport.stream(BlockPos.func_177975_b((BlockPos)area.getPoint1(), (BlockPos)area.getPoint2()).spliterator(), false);
    }

    public static StructureBoundingBox toBoundingBox(BlockArea area) {
        return new StructureBoundingBox((Vec3i)area.getLowerCorner(), (Vec3i)area.getHigherCorner());
    }
}

