/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.arl.util.RotationHandler;
import vazkii.quark.world.entity.EntityArchaeologist;
import vazkii.quark.world.feature.Archaeologist;

public class ArchaeologistHouseGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkGeneratorFlat) && Archaeologist.dims.canSpawnHere(world) && random.nextDouble() < Archaeologist.chance) {
            int x = chunkX * 16 + 8 + random.nextInt(16);
            int z = chunkZ * 16 + 8 + random.nextInt(16);
            int y = random.nextInt(Archaeologist.maxY - Archaeologist.minY) + Archaeologist.minY;
            BlockPos pos = new BlockPos(x, y, z);
            this.setHouseAt(random, world, pos);
        }
    }

    private void setHouseAt(Random random, World world, BlockPos pos) {
        if (world.func_175623_d(pos) && world instanceof WorldServer) {
            BlockPos down = pos.func_177977_b();
            while (world.func_175623_d(down)) {
                if (!world.func_189509_E(down = down.func_177977_b())) continue;
                return;
            }
            EnumFacing facing = EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)];
            BlockPos placePos = down.func_177984_a();
            while (world.func_175623_d(placePos)) {
                if (!world.func_189509_E(placePos = placePos.func_177972_a(facing)) && world.func_175667_e(placePos)) continue;
                return;
            }
            IBlockState placeState = world.func_180495_p(placePos);
            if (placeState.func_185904_a() == Material.field_151576_e && placeState.func_185913_b()) {
                this.generateHouse((WorldServer)world, placePos, facing);
            }
        }
    }

    private void generateHouse(WorldServer world, BlockPos pos, EnumFacing face) {
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_186237_a(server, Archaeologist.HOUSE_STRUCTURE);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(RotationHandler.getRotationFromFacing((EnumFacing)face));
        BlockPos placePos = pos.func_177967_a(face, 7);
        template.func_186253_b((World)world, placePos, settings);
        Map dataBlocks = template.func_186258_a(placePos, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            String s = (String)entry.getValue();
            if (!s.equals("villager")) continue;
            BlockPos villagerPos = (BlockPos)entry.getKey();
            world.func_175698_g(villagerPos);
            EntityArchaeologist e = new EntityArchaeologist((World)world);
            e.func_70107_b(villagerPos.func_177958_n(), villagerPos.func_177956_o(), villagerPos.func_177952_p());
            world.func_72838_d((Entity)e);
        }
    }
}

