/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class NaturalBlazesInNether
extends Feature {
    public static int weight;
    public static int min;
    public static int max;
    public static boolean restrictToNetherrack;
    public static List<String> allowedBlocks;

    @Override
    public void setupConfig() {
        weight = this.loadPropInt("Spawn Weight", "The higher, the more will spawn", 5);
        min = this.loadPropInt("Smallest spawn group", "", 1);
        max = this.loadPropInt("Largest spawn group", "", 2);
        restrictToNetherrack = this.loadPropBool("Block restrictions", "Make naturally spawned blazes only spawn in allowed blocks", true);
        allowedBlocks = Arrays.asList(this.loadPropStringList("Allowed spawn blocks", "Only used if \" Block restrictions\" is enabled.", new String[]{Objects.toString(Blocks.field_150424_aL.getRegistryName()), Objects.toString(Blocks.field_150425_aM.getRegistryName()), Objects.toString(Blocks.field_189877_df.getRegistryName()), "quark:basalt"}));
    }

    @Override
    public void init() {
        Biome.SpawnListEntry blazeEntry = new Biome.SpawnListEntry(EntityBlaze.class, weight, min, max);
        BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).forEach(biome -> biome.func_76747_a(EnumCreatureType.MONSTER).add(blazeEntry));
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos;
        EntityBlaze blaze;
        WorldServer world;
        Block block;
        ResourceLocation res;
        if (restrictToNetherrack && !event.isSpawner() && event.getEntityLiving() instanceof EntityBlaze && event.getResult() != Event.Result.DENY && event.getEntityLiving().field_70170_p instanceof WorldServer && (res = (block = (world = (WorldServer)blaze.field_70170_p).func_180495_p((pos = (blaze = (EntityBlaze)event.getEntityLiving()).func_180425_c()).func_177977_b()).func_177230_c()).getRegistryName()) != null) {
            boolean allowedBlock = allowedBlocks.contains(res.toString());
            boolean fortress = world.func_72863_F().func_193413_a((World)world, "Fortress", pos);
            if (!fortress && !allowedBlock) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Naturally Spawning Blazes";
    }
}

