/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.management.feature.FavoriteItems;

public class DyeItemNames
extends Feature {
    private static final String TAG_DYE = "Quark:ItemNameDye";

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77942_o() && ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DYE, (int)-1) != -1) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int len = font.func_78256_a(stack.func_82833_r());
            String spaces = "";
            while (font.func_78256_a(spaces) < len) {
                spaces = spaces + " ";
            }
            event.getToolTip().set(0, spaces);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        int dye;
        ItemStack stack = event.getStack();
        if (!stack.func_190926_b() && stack.func_77942_o() && (dye = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DYE, (int)-1)) != -1) {
            int rgb = ItemDye.field_150922_c[Math.min(15, dye)];
            Color color = new Color(rgb);
            String name = stack.func_82833_r();
            if (FavoriteItems.isItemFavorited(stack)) {
                name = "   " + name;
            }
            if (stack.func_82837_s()) {
                name = TextFormatting.ITALIC + name;
            }
            Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)event.getX(), (float)event.getY(), color.getRGB());
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        int meta;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.func_190926_b() && !right.func_190926_b() && (meta = DyeUtils.rawDyeDamageFromStack((ItemStack)right)) != -1) {
            ItemStack out = left.func_77946_l();
            String name = event.getName();
            if (!name.trim().isEmpty()) {
                out.func_151001_c(name.trim());
            }
            ItemNBTHelper.setInt((ItemStack)out, (String)TAG_DYE, (int)right.func_77952_i());
            event.setOutput(out);
            event.setMaterialCost(1);
            event.setCost(3);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

