/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import vazkii.arl.recipe.MultiRecipe;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.tweaks.feature.SlabsToBlocks;

public class StairsMakeMore
extends Feature {
    public static final Map<IBlockState, ItemStack> stairs = new HashMap<IBlockState, ItemStack>();
    public static int targetSize;
    public static int originalSize;
    public static boolean reversionRecipe;
    public static boolean enableSlabToStair;
    private MultiRecipe slabMultiRecipe;
    private MultiRecipe returnMultiRecipe;

    @Override
    public void setupConfig() {
        targetSize = this.loadPropInt("Target stack size (must be a divisor of 24 if 'Reversion recipe' is enabled)", "", 8);
        originalSize = this.loadPropInt("Vanilla stack size", "The stack size for the vanilla stair recipe, used for automatically detecting stair recipes", 4);
        reversionRecipe = this.loadPropBool("Add stairs to blocks recipe", "", true);
        enableSlabToStair = this.loadPropBool("Enable Slab to Stairs Recipe", "This recipe can only be enabled if the \"Slabs to blocks recipe\" feature is.", true);
    }

    @Override
    public void postPreInit() {
        if (enableSlabToStair) {
            this.slabMultiRecipe = new MultiRecipe(new ResourceLocation("quark", "slabs_to_stairs"));
        }
        if (reversionRecipe) {
            this.returnMultiRecipe = new MultiRecipe(new ResourceLocation("quark", "stairs_to_blocks"));
        }
    }

    public static ItemStack findResult(NonNullList<Ingredient> ingredients, int expected) {
        ItemStack outStack = ItemStack.field_190927_a;
        int inputItems = 0;
        for (Ingredient ingredient : ingredients) {
            ItemStack recipeItem = ItemStack.field_190927_a;
            ItemStack[] matches = ingredient.func_193365_a();
            if (matches.length > 0) {
                recipeItem = matches[0];
            }
            if (recipeItem == null || recipeItem.func_190926_b()) continue;
            if (outStack.func_190926_b()) {
                outStack = recipeItem;
            }
            if (ItemStack.func_179545_c((ItemStack)outStack, (ItemStack)recipeItem)) {
                ++inputItems;
                continue;
            }
            outStack = ItemStack.field_190927_a;
            break;
        }
        if (inputItems != expected) {
            return ItemStack.field_190927_a;
        }
        return outStack;
    }

    @Override
    public void postInit() {
        ArrayList recipeList = new ArrayList(CraftingManager.field_193380_a.func_148742_b());
        for (ResourceLocation res : recipeList) {
            NonNullList recipeItems;
            ItemStack outStack;
            Item outputItem;
            Block outputBlock;
            IRecipe recipe = (IRecipe)Objects.requireNonNull(CraftingManager.field_193380_a.func_82594_a((Object)res));
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b() || output.func_190916_E() != originalSize || !((outputBlock = Block.func_149634_a((Item)(outputItem = output.func_77973_b()))) instanceof BlockStairs)) continue;
            output.func_190920_e(targetSize);
            if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || (outStack = StairsMakeMore.findResult((NonNullList<Ingredient>)(recipeItems = recipe instanceof ShapedRecipes ? ((ShapedRecipes)recipe).field_77574_d : recipe.func_192400_c()), 6)).func_190926_b()) continue;
            ItemStack outCopy = outStack.func_77946_l();
            if (outCopy.func_77952_i() == Short.MAX_VALUE) {
                outCopy.func_77964_b(0);
            }
            outCopy.func_190920_e(24 / targetSize);
            ItemStack in = output.func_77946_l();
            in.func_190920_e(1);
            if (in.func_77973_b() instanceof ItemBlock && outCopy.func_77973_b() instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)outCopy.func_77973_b());
                stairs.put(block.func_176203_a(outCopy.func_77952_i()), in);
            }
            if (!reversionRecipe) continue;
            RecipeHandler.addShapelessOreDictRecipe((MultiRecipe)this.returnMultiRecipe, (ItemStack)outCopy, (Object[])new Object[]{in, in, in, in});
        }
    }

    @Override
    public void finalInit() {
        if (enableSlabToStair && !stairs.isEmpty() && !SlabsToBlocks.slabs.isEmpty()) {
            for (IBlockState state : stairs.keySet()) {
                ItemStack stair;
                if (!SlabsToBlocks.slabs.containsKey(state) || (stair = stairs.get(state).func_77946_l()).func_190926_b()) continue;
                stair.func_190920_e(targetSize / 2);
                ItemStack slab = SlabsToBlocks.slabs.get(state);
                RecipeHandler.addOreDictRecipe((MultiRecipe)this.slabMultiRecipe, (ItemStack)stair, (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), slab});
            }
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

