/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.module.Feature;
import vazkii.quark.building.item.ItemTrowel;

public class UsageTicker
extends Feature {
    public static List<TickerElement> elements;
    public static boolean invert;
    public static int shiftLeft;
    public static int shiftRight;

    @Override
    public void setupConfig() {
        elements = new ArrayList<TickerElement>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            String config = "Enable " + WordUtils.capitalize((String)slot.func_188450_d());
            if (!this.loadPropBool(config, "", true)) continue;
            elements.add(new TickerElement(slot));
        }
        invert = this.loadPropBool("Invert Displays", "Switch the armor display to the off hand side and the hand display to the main hand side", false);
        shiftLeft = this.loadPropInt("Left Side Offset", "", 0);
        shiftRight = this.loadPropInt("Right Side Offset", "", 0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                elements.forEach(ticker -> ticker.tick((EntityPlayer)mc.field_71439_g));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution res = event.getResolution();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float partial = event.getPartialTicks();
            elements.forEach(arg_0 -> UsageTicker.lambda$renderHUD$1(res, (EntityPlayer)player, partial, arg_0));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    private static /* synthetic */ void lambda$renderHUD$1(ScaledResolution res, EntityPlayer player, float partial, TickerElement ticker) {
        ticker.render(res, player, invert, partial);
    }

    public static class TickerElement {
        private static final int MAX_TIME = 60;
        private static final int ANIM_TIME = 5;
        public int liveTicks;
        public final EntityEquipmentSlot slot;
        public ItemStack currStack = ItemStack.field_190927_a;
        public int currCount;

        public TickerElement(EntityEquipmentSlot slot) {
            this.slot = slot;
        }

        @SideOnly(value=Side.CLIENT)
        public void tick(EntityPlayer player) {
            ItemStack heldStack = this.getStack(player);
            int count = this.getStackCount(player, heldStack);
            if ((heldStack = this.getDisplayedStack(heldStack, count)).func_190926_b()) {
                this.liveTicks = 0;
            } else if (this.shouldChange(heldStack, this.currStack, count, this.currCount)) {
                boolean animatingOut;
                boolean done = this.liveTicks == 0;
                boolean animatingIn = this.liveTicks > 55;
                boolean bl = animatingOut = this.liveTicks < 5 && !done;
                if (animatingOut) {
                    this.liveTicks = 60 - this.liveTicks;
                } else if (!animatingIn) {
                    this.liveTicks = !done ? 55 : 60;
                }
            } else if (this.liveTicks > 0) {
                --this.liveTicks;
            }
            this.currCount = count;
            this.currStack = heldStack;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(ScaledResolution res, EntityPlayer player, boolean invert, float partialTicks) {
            if (this.liveTicks > 0) {
                float mul;
                float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                float x = (float)res.func_78326_a() / 2.0f;
                float y = (float)res.func_78328_b() - anim;
                int armorWidth = 80;
                int heldWidth = 40;
                int barWidth = 190;
                boolean armor = this.slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR;
                EnumHandSide primary = player.func_184591_cq();
                EnumHandSide ourSide = armor != invert ? primary : primary.func_188468_a();
                int slots = armor ? 4 : 2;
                int index = slots - this.slot.func_188454_b() - 1;
                float f = mul = ourSide == EnumHandSide.LEFT ? -1.0f : 1.0f;
                if (ourSide != primary && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                    barWidth += 58;
                }
                Minecraft mc = Minecraft.func_71410_x();
                x += (float)barWidth / 2.0f * mul + (float)(index * 20);
                if (ourSide == EnumHandSide.LEFT) {
                    x -= (float)(slots * 20);
                    x += (float)shiftLeft;
                } else {
                    x += (float)shiftRight;
                }
                ItemStack stack = this.getRenderedStack(player);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                RenderHelper.func_74520_c();
                mc.func_175599_af().func_180450_b(stack, 0, 0);
                mc.func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
            return !prevStack.func_77969_a(currStack) || currentTotal != pastTotal;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getStack(EntityPlayer player) {
            return player.func_184582_a(this.slot);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getDisplayedStack(ItemStack stack, int count) {
            boolean verifySize = true;
            if (stack.func_77973_b() instanceof ItemBow && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) == 0) {
                stack = new ItemStack(Items.field_151032_g);
                verifySize = false;
            }
            if (stack.func_77973_b() instanceof ItemTrowel) {
                stack = ItemTrowel.getLastStack(stack);
                verifySize = false;
            }
            if (!stack.func_77985_e() && this.slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                return ItemStack.field_190927_a;
            }
            if (verifySize && stack.func_77985_e() && count == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getRenderedStack(EntityPlayer player) {
            int count;
            ItemStack stack = this.getStack(player);
            ItemStack displayStack = this.getDisplayedStack(stack, count = this.getStackCount(player, stack)).func_77946_l();
            if (displayStack != stack) {
                count = this.getStackCount(player, displayStack);
            }
            displayStack.func_190920_e(count);
            return displayStack;
        }

        @SideOnly(value=Side.CLIENT)
        public int getStackCount(EntityPlayer player, ItemStack stack) {
            if (!stack.func_77985_e()) {
                return 1;
            }
            Predicate<ItemStack> predicate = stackAt -> ItemStack.func_179545_c((ItemStack)stackAt, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)stackAt, (ItemStack)stack);
            if (stack.func_77973_b() == Items.field_151032_g) {
                predicate = stackAt -> stackAt.func_77973_b() instanceof ItemArrow;
            }
            int total = 0;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt2 = player.field_71071_by.func_70301_a(i);
                if (!predicate.test(stackAt2)) continue;
                total += stackAt2.func_190916_E();
            }
            return total;
        }
    }
}

