/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIGuiContainer;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.PageButton;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiRect;
import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiPartPageList
extends MGuiElementBase<GuiPartPageList> {
    public static StyleHandler.PropertyGroup dirPathProps = new StyleHandler.PropertyGroup("page_list.dir_path");
    public static StyleHandler.PropertyGroup dirButtonProps = new StyleHandler.PropertyGroup("page_list.dir_path.dir_buttons");
    public static StyleHandler.PropertyGroup headerProps = new StyleHandler.PropertyGroup("page_list.header");
    public static StyleHandler.PropertyGroup bodyProps = new StyleHandler.PropertyGroup("page_list.body");
    public static StyleHandler.PropertyGroup footerProps = new StyleHandler.PropertyGroup("page_list.footer");
    public static StyleHandler.PropertyGroup searchBoxProps = new StyleHandler.PropertyGroup("page_list.search");
    public static StyleHandler.PropertyGroup searchSettingsProps = new StyleHandler.PropertyGroup("page_list.search.settings_button");
    public static StyleHandler.PropertyGroup scrollProps = new StyleHandler.PropertyGroup("page_list.scroll_bar");
    public static StyleHandler.PropertyGroup scrollSliderProps = new StyleHandler.PropertyGroup("page_list.scroll_bar.scroll_slider");
    public PIPartRenderer headerRender = new PIPartRenderer(headerProps).setSideTrims(true, true, false, true);
    public PIPartRenderer dirPathRender = new PIPartRenderer(dirPathProps).setSideTrims(true, true, false, true);
    public PIPartRenderer dirButtonRender = new PIPartRenderer(dirButtonProps);
    public PIPartRenderer bodyRender = new PIPartRenderer(bodyProps).setSideTrims(true, false, false, true);
    public PIPartRenderer footerRender = new PIPartRenderer(footerProps);
    public PIPartRenderer scrollRenderer = new PIPartRenderer(scrollProps);
    public PIPartRenderer scrollSlideRenderer = new PIPartRenderer(scrollSliderProps);
    public final int HIDDEN_X_SIZE = 12;
    private final int NAV_BAR_SIZE = 14;
    private final int TITLE_BAR_SIZE = 0;
    private final int DIR_BAR_SIZE = 12;
    private final int FOOTER_SIZE = 16;
    private DisplayController controller;
    public boolean extended = true;
    private GuiSlideControl scrollBar;
    public GuiScrollElement scrollElement;
    private List<GuiButton> navButtons = new LinkedList<GuiButton>();
    private PIGuiContainer container;
    private String buttonController = "";
    public GuiTextField searchBox;
    public GuiButton backButton;
    public GuiButton forwardButton;
    public GuiButton toggleView;
    public GuiButton searchSettings;
    private String currentPage = "";

    public GuiPartPageList(PIGuiContainer container, DisplayController controller) {
        this.container = container;
        this.controller = controller;
    }

    public void addChildElements() {
        super.addChildElements();
        this.toggleView = (GuiButton)((GuiButton)new GuiButton().setSize(10, 10)).setHoverText(I18n.func_135052_a((String)"pi.button.toggle_nav_window.info", (Object[])new Object[0]));
        GuiTexture tex = new GuiTexture(0, 16, 6, 7, PITextures.PI_PARTS);
        tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> StyleHandler.getColour("page_list.hide_button." + (this.toggleView.isMouseOver(mouseX, mouseY) ? "hover" : "colour")).glColour());
        tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        tex.setTexXGetter(() -> this.extended ? 0 : 9);
        this.toggleView.addChild((MGuiElementBase)tex);
        this.toggleView.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setYPos(this.yPos() + (14 - this.toggleView.ySize()) / 2);
        });
        this.toggleView.setListener(() -> {
            this.extended = !this.extended;
        });
        ((GuiTexture)tex.setXPosMod(() -> this.maxXPos() - 10)).translate(0, 2);
        this.toggleView.setXPosMod(() -> this.maxXPos() - 11);
        this.addChild((MGuiElementBase)this.toggleView);
        this.backButton = (GuiButton)((GuiButton)new GuiButton().setSize(10, 12)).setHoverText(I18n.func_135052_a((String)"pi.button.go_back", (Object[])new Object[0]));
        tex = new GuiTexture(17, 24, 6, 8, PITextures.PI_PARTS);
        tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> {
            Colour c = StyleHandler.getColour("page_list.hide_button." + (this.backButton.isMouseOver(mouseX, mouseY) && !this.backButton.isDisabled() ? "hover" : "colour"));
            if (this.backButton.isDisabled()) {
                c = c.copy().set(this.changeShade(c.argb(), -0.5));
            }
            c.glColour();
        });
        tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        this.backButton.addChild((MGuiElementBase)tex);
        this.backButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setYPos(this.yPos() + (14 - this.backButton.ySize()) / 2);
        });
        ((GuiTexture)tex.setXPosMod(() -> this.maxXPos() - this.extendedXSize() + 6)).translate(0, 2);
        this.backButton.setXPosMod(() -> this.maxXPos() - this.extendedXSize() + 4);
        this.addChild((MGuiElementBase)this.backButton);
        this.backButton.setListener(() -> {
            this.controller.goBack();
            this.reloadPageButtons(true);
        });
        this.backButton.setEnabledCallback(() -> this.xSize() == this.extendedXSize());
        this.forwardButton = (GuiButton)((GuiButton)new GuiButton().setSize(10, 12)).setHoverText(I18n.func_135052_a((String)"pi.button.go_forward", (Object[])new Object[0]));
        tex = new GuiTexture(25, 24, 6, 8, PITextures.PI_PARTS);
        tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> {
            Colour c = StyleHandler.getColour("page_list.hide_button." + (this.forwardButton.isMouseOver(mouseX, mouseY) && !this.forwardButton.isDisabled() ? "hover" : "colour"));
            if (this.forwardButton.isDisabled()) {
                c = c.copy().set(this.changeShade(c.argb(), -0.5));
            }
            c.glColour();
        });
        tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        this.forwardButton.addChild((MGuiElementBase)tex);
        this.forwardButton.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setYPos(this.yPos() + (14 - this.forwardButton.ySize()) / 2);
        });
        ((GuiTexture)tex.setXPosMod(() -> this.maxXPos() - this.extendedXSize() + 10 + 6)).translate(0, 2);
        this.forwardButton.setXPosMod(() -> this.maxXPos() - this.extendedXSize() + 10 + 4);
        this.addChild((MGuiElementBase)this.forwardButton);
        this.forwardButton.setListener(() -> {
            this.controller.goForward();
            this.reloadPageButtons(true);
        });
        this.forwardButton.setEnabledCallback(() -> this.xSize() == this.extendedXSize());
        this.scrollBar = new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL);
        this.scrollBar.setXPosMod((guiSlideControl, integer) -> this.maxXPos() - this.scrollBar.xSize() - 2);
        this.scrollBar.setYPosMod((guiSlideControl, integer) -> this.yPos() + 14 + 0 + 2);
        this.scrollBar.setXSize(8);
        this.scrollBar.setBackgroundElement((MGuiElementBase)this.scrollRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
        this.scrollBar.setSliderElement((MGuiElementBase)this.scrollSlideRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
        this.scrollBar.getBackgroundElement().setXPosMod((o, integer) -> this.scrollBar.xPos()).setYPosMod((o, integer) -> this.scrollBar.yPos());
        this.scrollBar.getSliderElement().setXPosMod((o, integer) -> this.scrollBar.getInsetRect().x);
        this.scrollBar.setEnabledCallback(() -> this.extended);
        this.scrollElement = new GuiScrollElement();
        this.scrollElement.setVerticalScrollBar(this.scrollBar);
        this.scrollElement.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS);
        this.scrollElement.setStandardScrollBehavior();
        this.scrollElement.setXSizeMod((guiScrollElement, integer) -> this.xSize() - 12);
        this.scrollElement.setAllowedScrollAxes(true, false);
        this.addChild((MGuiElementBase)this.scrollElement);
        this.addSearchBox();
    }

    private void addSearchBox() {
        int settingsSize = 12;
        this.searchBox = new GuiTextField();
        this.searchBox.setXPosMod(() -> this.maxXPos() - this.extendedXSize() + 2);
        this.searchBox.addAndFireReloadCallback(field -> {
            field.setSize(this.extendedXSize() - settingsSize - 5, 12);
            field.setYPos(this.maxYPos() - 16 + 2);
        });
        this.searchBox.setChangeListener(() -> this.reloadPageButtons(false));
        this.searchBox.setFocusListener(focused -> {
            if (focused.booleanValue()) {
                this.resetCustomFilter();
                this.reloadPageButtons(false);
            }
        });
        this.searchBox.setEnabledCallback(() -> this.xSize() == this.extendedXSize());
        this.searchSettings = (GuiButton)((GuiButton)new GuiButton().setSize(settingsSize, settingsSize)).setHoverText(I18n.func_135052_a((String)"pi.button.search_settings", (Object[])new Object[0]));
        GuiTexture settingsTex = new GuiTexture(16, 0, settingsSize, settingsSize, PITextures.PI_PARTS);
        settingsTex.setXPosMod(() -> this.searchBox.maxXPos() + 1);
        settingsTex.setTexSizeOverride(16, 16);
        settingsTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> searchSettingsProps.glColour(mouseOver));
        settingsTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
        this.searchSettings.addChild((MGuiElementBase)settingsTex);
        this.searchSettings.setXPosMod(() -> this.searchBox.maxXPos() + 2);
        this.searchSettings.addAndFireReloadCallback(guiButton -> {
            GuiButton cfr_ignored_0 = (GuiButton)guiButton.setYPos(this.searchBox.yPos());
        });
        this.searchSettings.setListener(() -> {
            GuiPopUpDialogBase dialog = new GuiPopUpDialogBase((MGuiElementBase)this);
            dialog.setSize(this.searchBox.xSize(), PIConfig.SearchMode.values().length * 13 + 5);
            dialog.addChild(new StyledGuiRect("user_dialogs").setPosAndSize((MGuiElementBase)dialog));
            dialog.setPos(this.searchBox.xPos(), this.searchBox.yPos() - dialog.ySize());
            int y = dialog.yPos() + 3;
            for (PIConfig.SearchMode mode : PIConfig.SearchMode.values()) {
                StyledGuiButton button = new StyledGuiButton("user_dialogs.button_style");
                button.setTrim(false);
                button.setText(I18n.func_135052_a((String)mode.getUnlocalizedName(), (Object[])new Object[0]));
                ((GuiButton)button.setPos(dialog.xPos() + 3, y)).setSize(dialog.xSize() - 6, 12);
                button.setToggleMode(true).setToggleStateSupplier(() -> PIConfig.searchMode == mode);
                button.setListener(() -> this.changeSearchMode(mode));
                dialog.addChild((MGuiElementBase)button);
                y += 13;
            }
            dialog.show();
        });
        this.searchSettings.setEnabledCallback(() -> this.xSize() == this.extendedXSize());
        this.addChild((MGuiElementBase)this.searchBox);
        this.addChild((MGuiElementBase)this.searchSettings);
    }

    private void changeSearchMode(PIConfig.SearchMode mode) {
        PIConfig.searchMode = mode;
        PIConfig.save();
        this.reloadPageButtons(false);
    }

    public void reloadElement() {
        String newController = this.controller.getButtonController();
        double pos = this.scrollBar.getRawPos();
        this.setXSize(this.extended ? this.extendedXSize() : 12);
        this.scrollBar.setYSize(this.ySize() - 14 - 0 - 16 - 3);
        this.scrollBar.getBackgroundElement().setSize((MGuiElementBase)this.scrollBar);
        this.scrollElement.setPos(this.xPos() + 12, this.yPos() + 0 + 14 + 2);
        this.scrollElement.setSize(this.xSize() - 12, this.ySize() - 0 - 14 - 16 - 3);
        this.scrollElement.setListSpacing(1);
        this.currentPage = this.controller.getActiveTab().pageURI;
        this.reloadPageButtons(true);
        super.reloadElement();
        if (this.buttonController.equals(newController)) {
            this.scrollBar.updateRawPos(pos);
        }
        this.buttonController = newController;
    }

    public void setPageFilter(List<String> pageURIs) {
        this.reloadPageButtons(true, pageURIs);
    }

    private void reloadPageButtons(boolean updateNav) {
        if (this.searchBox.getText().equals("[Custom Filter]")) {
            return;
        }
        this.reloadPageButtons(updateNav, null);
    }

    private void reloadPageButtons(boolean updateNav, @Nullable List<String> pageOverride) {
        AbstractList pages;
        this.scrollElement.clearElements();
        this.scrollElement.resetScrollPositions();
        String search = this.searchBox.getText().toLowerCase();
        if (pageOverride != null) {
            pages = new ArrayList();
            for (String page2 : pageOverride) {
                DocumentationPage docPage = DocumentationManager.getPage(page2);
                if (page2 == null) continue;
                pages.add((DocumentationPage)docPage);
            }
            this.searchBox.setText("[Custom Filter]");
        } else {
            pages = !search.isEmpty() && !updateNav ? this.searchPages(search, PIConfig.searchMode) : this.controller.getSubPages();
        }
        pages.sort(Comparator.comparingInt(page -> page.treeDepth * 5000 + page.getSortingWeight()));
        this.addPageButtons(pages, pageOverride == null);
        if (updateNav) {
            this.updateNavButtons();
        }
    }

    private LinkedList<DocumentationPage> searchPages(String search, PIConfig.SearchMode mode) {
        LinkedList<DocumentationPage> candidates = new LinkedList<DocumentationPage>();
        LinkedList<DocumentationPage> results = new LinkedList<DocumentationPage>();
        DocumentationPage activePage = this.controller.getActiveTab().getDocPage();
        switch (mode) {
            case EVERYWHERE: {
                candidates.addAll(DocumentationManager.getAllPages());
                break;
            }
            case SELECTED_MOD: {
                DataUtils.addIf(DocumentationManager.getAllPages(), candidates, page -> page.getModid().equals(activePage.getModid()));
                break;
            }
            case PAGE_SUB_PAGES: {
                this.addChildPagesRecursively(activePage, candidates);
                break;
            }
            case PAGE_ONLY: {
                candidates.addAll(activePage.getSubPages());
            }
        }
        for (DocumentationPage page2 : candidates) {
            if (!this.doesPageMatchSearch(page2, search) || page2.isHidden() && !PIConfig.editMode()) continue;
            results.add(page2);
        }
        return results;
    }

    private void addChildPagesRecursively(DocumentationPage page, LinkedList<DocumentationPage> list) {
        for (DocumentationPage child : page.getSubPages()) {
            list.add(child);
            this.addChildPagesRecursively(child, list);
        }
    }

    private boolean doesPageMatchSearch(DocumentationPage page, String search) {
        if (page.getDisplayName().toLowerCase().contains(search)) {
            return true;
        }
        for (ContentRelation relation : page.getRelations()) {
            if (!relation.getLocalizedName().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    private void addPageButtons(List<DocumentationPage> buttons, boolean addBack) {
        DocumentationPage current = DocumentationManager.getPage(this.currentPage);
        if (current != null && current.getParent() != null && !this.currentPage.equals("[pi_root_page]")) {
            if (current.getSubPages().isEmpty()) {
                current = current.getParent();
            }
            if (current != null && current.getParent() != null) {
                PageButton back = new PageButton(current.getParent(), this.controller, true);
                back.setXSize(this.scrollElement.xSize() - (this.scrollBar.xSize() + 4));
                back.setXPosMod((guiButton, integer) -> this.scrollElement.maxXPos() - guiButton.xSize() - (this.scrollBar.xSize() + 3));
                this.scrollElement.addElement((MGuiElementBase)back);
            }
        }
        for (DocumentationPage page : buttons) {
            if (page.isHidden() && !PIConfig.editMode()) continue;
            PageButton button = new PageButton(page, this.controller);
            button.setXSize(this.scrollElement.xSize() - (this.scrollBar.xSize() + 4));
            button.setXPosMod((guiButton, integer) -> this.scrollElement.maxXPos() - guiButton.xSize() - (this.scrollBar.xSize() + 3));
            this.scrollElement.addElement((MGuiElementBase)button);
        }
    }

    public boolean onUpdate() {
        String openPage;
        int targetSize = this.extended ? this.extendedXSize() : 12;
        int moveSpeed = 30;
        if (this.xSize() != targetSize) {
            this.addToXSize(MathHelper.clip((int)(targetSize - this.xSize()), (int)(-moveSpeed), (int)moveSpeed));
            this.container.pageListMotionUpdate();
        }
        if (!this.currentPage.equals(openPage = this.controller.getActiveTab().pageURI)) {
            this.currentPage = openPage;
            this.reloadPageButtons(true);
        }
        this.searchBox.setTextColor(searchBoxProps.textColour());
        this.searchBox.fillColour = searchBoxProps.colour();
        this.searchBox.borderColour = searchBoxProps.border();
        return super.onUpdate();
    }

    public void updateNavButtons() {
        DisplayController.TabData activeTab = this.controller.getActiveTab();
        this.backButton.setDisabled(!activeTab.canGoBack());
        this.forwardButton.setDisabled(!activeTab.canGoForward());
        DocumentationPage page = this.controller.getActiveTab().getDocPage();
        this.currentPage = page.getPageURI();
        page = page.getParent();
        this.removeChildByGroup("TREE_BUTTON_GROUP");
        this.navButtons.clear();
        int currentLength = 0;
        while (page != null) {
            String name = page.getDisplayName().length() > 18 ? page.getDisplayName().substring(0, 16) + ".." : page.getDisplayName();
            int height = this.fontRenderer.func_78256_a(name) + 6;
            if (currentLength + height > this.ySize() - 14 - 16) {
                if (currentLength != 0) break;
                name = this.fontRenderer.func_78269_a(page.getDisplayName(), this.ySize() - 14 - 16 - 8) + "..";
                height = this.fontRenderer.func_78256_a(name) + 6;
            }
            GuiButton newButton = new StyledGuiButton(this.dirButtonRender).setText(name).setTrim(false).setShadow(false).setRotation(GuiAlign.TextRotation.ROT_CC);
            newButton.setSize(10, height);
            newButton.textXOffset = 1;
            newButton.setYPos(this.yPos() + 14 + 1);
            newButton.setXPosMod((guiButton, integer) -> this.xPos() + 1);
            newButton.addToGroup("TREE_BUTTON_GROUP");
            DocumentationPage thisPage = page;
            newButton.setListener(() -> {
                this.resetCustomFilter();
                this.controller.openPage(thisPage.getPageURI(), false);
            });
            this.addChild((MGuiElementBase)newButton);
            for (GuiButton button : this.navButtons) {
                button.translate(0, height);
            }
            this.navButtons.add(newButton);
            currentLength += newButton.ySize();
            if (page.getParent() == page) {
                page = null;
                continue;
            }
            page = page.getParent();
        }
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.headerRender.render(this, this.xPos(), this.yPos(), this.xSize() + 1, 14);
        this.dirPathRender.render(this, this.xPos(), this.yPos() + 14, 12, this.ySize() - 14 - 16);
        this.bodyRender.render(this, this.xPos() + 12, this.yPos() + 14 + 0, this.xSize() - 12 + 1, this.ySize() - 14 - 16 - 0);
        this.footerRender.render(this, this.xPos(), this.yPos() + this.ySize() - 16, this.xSize() + 1, 16);
        String navTitle = I18n.func_135052_a((String)"pi.gui.navigation.title", (Object[])new Object[0]);
        int width = this.fontRenderer.func_78256_a(navTitle);
        this.drawCustomString(this.fontRenderer, navTitle, (float)this.xPos() + (float)this.xSize() / 2.0f - (float)width / 2.0f, this.yPos() + 14 - this.fontRenderer.field_78288_b - 1, this.xSize() - 20, 0xFFFFFF, GuiAlign.LEFT, GuiAlign.TextRotation.NORMAL, false, true, false);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        boolean ret = super.keyTyped(typedChar, keyCode);
        if (!ret && keyCode == 14 && !this.backButton.isDisabled() && this.backButton.isEnabled()) {
            this.backButton.onPressed(this.backButton.xPos() + 1, this.backButton.yPos() + 1, 0);
            return true;
        }
        return ret;
    }

    public void setFullyExtended() {
        this.extended = true;
        this.setXSize(this.extendedXSize());
        this.container.pageListMotionUpdate();
    }

    private int extendedXSize() {
        return this.container.getListMaxWidth().get();
    }

    private void resetCustomFilter() {
        if (this.searchBox.getText().equals("[Custom Filter]")) {
            this.searchBox.setText("");
        }
    }
}

