/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client;

import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.ContentInfo;
import com.brandon3055.projectintelligence.client.gui.GuiContentSelect;
import com.brandon3055.projectintelligence.client.gui.GuiProjectIntelligence;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiRect;
import com.brandon3055.projectintelligence.client.gui.swing.PIEditor;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.Display;

public class PIGuiHelper {
    public static PIEditor editor = null;
    public static ConcurrentLinkedDeque<String> errorCache = new ConcurrentLinkedDeque();
    private static LinkedList<String> entitySelectionList = new LinkedList();
    private static LinkedList<String> playerInventory = new LinkedList();

    public static void displayError(String error) {
        PIGuiHelper.displayError(error, false);
    }

    public static void displayError(String error, boolean noRepeat) {
        if (noRepeat && errorCache.contains(error)) {
            return;
        }
        LogHelperBC.error((Object)("[Pi Reported Error]: " + error));
        errorCache.add(error);
        GuiProjectIntelligence.updateErrorDialog = true;
    }

    public static void displayLinkConfirmDialog(MGuiElementBase parent, String link) {
        URI uri;
        try {
            uri = new URI(link);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            PIGuiHelper.displayError("Failed to open link due to unknown error!\n" + e.getMessage());
            return;
        }
        GuiPopUpDialogBase dialog = new GuiPopUpDialogBase(parent);
        dialog.setXSize(300);
        dialog.setDragBar(12);
        dialog.setCloseOnCapturedClick(true);
        StyledGuiRect background = new StyledGuiRect("user_dialogs");
        dialog.addChild((MGuiElementBase)background);
        GuiLabel infoLabel = new GuiLabel(I18n.func_135052_a((String)"pi.md.link_confirmation.txt", (Object[])new Object[0]));
        infoLabel.setWrap(true).setShadow(false);
        infoLabel.setTextColour(StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()));
        infoLabel.setXSize(dialog.xSize() - 30);
        infoLabel.setHeightForText();
        infoLabel.setRelPos(15, 10);
        dialog.addChild((MGuiElementBase)infoLabel);
        GuiLabel urlLabel = new GuiLabel("\"" + link + "\"");
        urlLabel.setWrap(true).setShadow(false);
        urlLabel.setTextColour(StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()));
        urlLabel.setXSize(dialog.xSize() - 30);
        urlLabel.setHeightForText();
        urlLabel.setPos(infoLabel.xPos(), infoLabel.maxYPos() + 10);
        dialog.addChild((MGuiElementBase)urlLabel);
        StyledGuiButton yesButton = new StyledGuiButton("user_dialogs." + StyleHandler.StyleType.BUTTON_STYLE.getName());
        yesButton.setText(I18n.func_135052_a((String)"pi.button.yes", (Object[])new Object[0]));
        yesButton.setSize(80, 15);
        yesButton.setPos(dialog.xPos() + 15, urlLabel.maxYPos() + 10);
        yesButton.setListener(() -> Utils.openWebLink((URI)uri));
        dialog.addChild((MGuiElementBase)yesButton);
        StyledGuiButton copyButton = new StyledGuiButton("user_dialogs." + StyleHandler.StyleType.BUTTON_STYLE.getName());
        copyButton.setText(I18n.func_135052_a((String)"pi.button.copy_to_clipboard", (Object[])new Object[0]));
        copyButton.setSize(108, 15);
        copyButton.setRelPos((MGuiElementBase)yesButton, 81, 0);
        copyButton.setListener(() -> Utils.setClipboardString((String)link));
        dialog.addChild((MGuiElementBase)copyButton);
        StyledGuiButton cancelButton = new StyledGuiButton("user_dialogs." + StyleHandler.StyleType.BUTTON_STYLE.getName());
        cancelButton.setText(I18n.func_135052_a((String)"pi.button.cancel", (Object[])new Object[0]));
        cancelButton.setSize(80, 15);
        cancelButton.setRelPos((MGuiElementBase)copyButton, 109, 0);
        dialog.addChild((MGuiElementBase)cancelButton);
        dialog.setYSize(cancelButton.maxYPos() + 10 - dialog.yPos());
        background.setPosAndSize((MGuiElementBase)dialog);
        dialog.showCenter(parent.displayZLevel + 50);
    }

    public static synchronized List<String> getSupportedMods() {
        return ImmutableList.copyOf(DocumentationManager.getDocumentedMods());
    }

    public static void displayEditor() {
        if (editor == null) {
            editor = new PIEditor();
            editor.reload();
        }
        editor.setVisible(true);
        editor.setExtendedState(0);
        editor.toFront();
        PIGuiHelper.centerWindowOnMC(editor);
    }

    public static void closeEditor() {
        if (editor != null && editor.isVisible()) {
            editor.dispose();
        }
    }

    public static void centerWindowOnMC(Component window) {
        int centerX = Display.getX() + Display.getWidth() / 2;
        int centerY = Display.getY() + Display.getHeight() / 2;
        window.setLocation(centerX - window.getWidth() / 2, Math.max(0, centerY - window.getHeight() / 2));
    }

    public static void centerWindowScreen(Component window) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point centerPoint = ge.getCenterPoint();
        int centerX = (int)centerPoint.getX();
        int centerY = (int)centerPoint.getY();
        window.setLocation(centerX - window.getWidth() / 2, Math.max(0, centerY - window.getHeight() / 2));
    }

    public static void centerWindowOn(Component window, Component centerOn) {
        int centerX = centerOn.getX() + centerOn.getWidth() / 2;
        int centerY = centerOn.getY() + centerOn.getHeight() / 2;
        window.setLocation(centerX - window.getWidth() / 2, Math.max(0, centerY - window.getHeight() / 2));
    }

    public static synchronized LinkedList<String> getEntitySelectionList() {
        if (entitySelectionList.isEmpty()) {
            for (EntityList.EntityEggInfo info : EntityList.field_75627_a.values()) {
                entitySelectionList.add(info.field_75613_a.toString());
            }
            Collections.sort(entitySelectionList);
        }
        return entitySelectionList;
    }

    public static synchronized LinkedList<String> getPlayerInventory() {
        return playerInventory;
    }

    public static void updatePlayerInventory(EntityPlayer player) {
        playerInventory.clear();
        player.field_71071_by.field_70462_a.stream().filter(stack -> !stack.func_190926_b()).forEach(stack -> playerInventory.add(new StackReference(stack).toString()));
        player.field_71071_by.field_70460_b.stream().filter(stack -> !stack.func_190926_b()).forEach(stack -> playerInventory.add(new StackReference(stack).toString()));
        player.field_71071_by.field_184439_c.stream().filter(stack -> !stack.func_190926_b()).forEach(stack -> playerInventory.add(new StackReference(stack).toString()));
    }

    public static void openContentChooser(@Nullable ContentInfo contentInfo, GuiContentSelect.SelectMode mode, Consumer<ContentInfo> action, ContentInfo.ContentType ... types) {
        ProcessHandlerClient.syncTask(() -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiContentSelect) {
                return;
            }
            GuiContentSelect gui = new GuiContentSelect(Minecraft.func_71410_x().field_71462_r, mode, contentInfo, types);
            gui.setSelectCallBack(action);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        });
    }
}

