/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class EMCHelper {
    public static long consumePlayerFuel(EntityPlayer player, long minFuel) {
        IItemEmc itemEmc;
        if (player.field_71075_bZ.field_75098_d) {
            return minFuel;
        }
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        boolean metRequirement = false;
        long emcConsumed = 0L;
        ItemStack offhand = player.func_184592_cb();
        if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof IItemEmc && (itemEmc = (IItemEmc)offhand.func_77973_b()).getStoredEmc(offhand) >= minFuel) {
            itemEmc.extractEmc(offhand, minFuel);
            player.field_71069_bz.func_75142_b();
            return minFuel;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc2 = (IItemEmc)stack.func_77973_b();
                if (itemEmc2.getStoredEmc(stack) < minFuel) continue;
                itemEmc2.extractEmc(stack, minFuel);
                player.field_71069_bz.func_75142_b();
                return minFuel;
            }
            if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
            long emc = EMCHelper.getEmcValue(stack);
            int toRemove = (int)Math.ceil((double)(minFuel - emcConsumed) / (double)emc);
            if (stack.func_190916_E() >= toRemove) {
                map.put(i, toRemove);
                emcConsumed += emc * (long)toRemove;
                metRequirement = true;
                continue;
            }
            map.put(i, stack.func_190916_E());
            if ((emcConsumed += emc * (long)stack.func_190916_E()) < minFuel) continue;
            metRequirement = true;
        }
        if (metRequirement) {
            for (Map.Entry entry : map.entrySet()) {
                inv.extractItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue(), false);
            }
            player.field_71069_bz.func_75142_b();
            return emcConsumed;
        }
        return -1L;
    }

    public static boolean doesBlockHaveEmc(Block block) {
        return block != null && EMCHelper.doesItemHaveEmc(new ItemStack(block));
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return false;
        }
        if (ItemHelper.isDamageable(stack)) {
            iStack = iStack.withMeta(0);
        }
        return EMCMapper.mapContains(iStack);
    }

    public static boolean doesItemHaveEmc(Item item) {
        return item != null && EMCHelper.doesItemHaveEmc(new ItemStack(item));
    }

    public static long getEmcValue(Block block) {
        SimpleStack stack = new SimpleStack(new ItemStack(block));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0L;
    }

    public static long getEmcValue(Item item) {
        SimpleStack stack = new SimpleStack(new ItemStack(item));
        if (stack.isValid() && EMCMapper.mapContains(stack)) {
            return EMCMapper.getEmcValue(stack);
        }
        return 0L;
    }

    public static long getEmcValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0L;
        }
        SimpleStack iStack = new SimpleStack(stack);
        if (!iStack.isValid()) {
            return 0L;
        }
        if (!EMCMapper.mapContains(iStack) && ItemHelper.isDamageable(stack)) {
            if (EMCMapper.mapContains(iStack = iStack.withMeta(0))) {
                long emc = EMCMapper.getEmcValue(iStack);
                int relDamage = stack.func_77958_k() + 1 - stack.func_77952_i();
                if (relDamage <= 0) {
                    return emc;
                }
                long result = emc * (long)relDamage;
                if (result <= 0L) {
                    return emc;
                }
                boolean positive = (result /= (long)stack.func_77958_k()) > 0L;
                if (positive && (result += EMCHelper.getEnchantEmcBonus(stack)) < 0L) {
                    return emc;
                }
                positive = result > 0L;
                if (positive && (result += EMCHelper.getStoredEMCBonus(stack)) < 0L) {
                    return emc;
                }
                if (result <= 0L) {
                    return 1L;
                }
                return result;
            }
        } else if (EMCMapper.mapContains(iStack)) {
            return EMCMapper.getEmcValue(iStack) + EMCHelper.getEnchantEmcBonus(stack) + EMCHelper.getStoredEMCBonus(stack);
        }
        return 0L;
    }

    private static long getEnchantEmcBonus(ItemStack stack) {
        long result = 0L;
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchants.isEmpty()) {
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment ench = (Enchantment)entry.getKey();
                if (ench == null || ench.func_77324_c().func_185270_a() == 0) continue;
                result += 5000L / (long)ench.func_77324_c().func_185270_a() * (long)((Integer)entry.getValue()).intValue();
            }
        }
        return result;
    }

    public static long getEmcSellValue(ItemStack stack) {
        long originalValue = EMCHelper.getEmcValue(stack);
        if (originalValue == 0L) {
            return 0L;
        }
        long emc = (long)Math.floor((double)originalValue * EMCMapper.covalenceLoss);
        if (emc < 1L) {
            emc = EMCMapper.covalenceLossRounding ? 1L : 0L;
        }
        return emc;
    }

    public static String getEmcSellString(ItemStack stack, int stackSize) {
        if (EMCMapper.covalenceLoss == 1.0) {
            return " ";
        }
        BigInteger emc = BigInteger.valueOf(EMCHelper.getEmcSellValue(stack));
        return " (" + Constants.EMC_FORMATTER.format(emc.multiply(BigInteger.valueOf(stackSize))) + ")";
    }

    public static long getKleinStarMaxEmc(ItemStack stack) {
        return Constants.MAX_KLEIN_EMC[stack.func_77952_i()];
    }

    private static long getStoredEMCBonus(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StoredEMC")) {
            return stack.func_77978_p().func_74763_f("StoredEMC");
        }
        if (stack.func_77973_b() instanceof IItemEmc) {
            return ((IItemEmc)stack.func_77973_b()).getStoredEmc(stack);
        }
        return 0L;
    }

    public static long getEMCPerDurability(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0L;
        }
        if (ItemHelper.isItemRepairable(stack)) {
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.func_77964_b(0);
            long emc = (long)Math.ceil((double)EMCHelper.getEmcValue(stackCopy) / (double)stack.func_77958_k());
            return emc > 1L ? emc : 1L;
        }
        return 1L;
    }

    public static long removeFractionalEMC(ItemStack stack, double amount) {
        double unprocessedEMC = ItemHelper.getOrCreateCompound(stack).func_74769_h("UnprocessedEMC");
        long toRemove = (long)(unprocessedEMC += amount);
        stack.func_77978_p().func_74780_a("UnprocessedEMC", unprocessedEMC -= (double)toRemove);
        return toRemove;
    }
}

