/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.api.tile.IEmcProvider;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class RelayMK1Tile
extends TileEmc
implements IEmcAcceptor,
IEmcProvider {
    private final ItemStackHandler input;
    private final ItemStackHandler output = new TileEmc.StackHandler(1);
    private final IItemHandler automationInput;
    private final IItemHandler automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.output, WrappedItemHandler.WriteMode.IN_OUT){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.IITEMEMC.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc item = (IItemEmc)stack.func_77973_b();
                if (item.getStoredEmc(stack) >= item.getMaximumEmc(stack)) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private final long chargeRate;
    private double bonusEMC;

    public RelayMK1Tile() {
        this(7, 100000L, 64L);
    }

    RelayMK1Tile(int sizeInv, long maxEmc, long chargeRate) {
        super(maxEmc);
        this.chargeRate = chargeRate;
        this.input = new TileEmc.StackHandler(sizeInv){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.RELAY_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == EnumFacing.DOWN) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationOutput);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInput);
        }
        return (T)super.getCapability(cap, side);
    }

    private ItemStack getCharging() {
        return this.output.getStackInSlot(0);
    }

    private ItemStack getBurn() {
        return this.input.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getOutput() {
        return this.output;
    }

    public void func_73660_a() {
        ItemStack chargeable;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sendEmc();
        ItemHelper.compactInventory((IItemHandlerModifiable)this.input);
        ItemStack stack = this.getBurn();
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)stack.func_77973_b();
                long emcVal = itemEmc.getStoredEmc(stack);
                if (emcVal > this.chargeRate) {
                    emcVal = this.chargeRate;
                }
                if (emcVal > 0L && this.getStoredEmc() + emcVal <= this.getMaximumEmc()) {
                    this.addEMC(emcVal);
                    itemEmc.extractEmc(stack, emcVal);
                }
            } else {
                long emcVal = EMCHelper.getEmcSellValue(stack);
                if (emcVal > 0L && this.getStoredEmc() + emcVal <= this.getMaximumEmc()) {
                    this.addEMC(emcVal);
                    this.getBurn().func_190918_g(1);
                }
            }
        }
        if (!(chargeable = this.getCharging()).func_190926_b() && this.getStoredEmc() > 0L && chargeable.func_77973_b() instanceof IItemEmc) {
            this.chargeItem(chargeable);
        }
    }

    private void sendEmc() {
        if (this.getStoredEmc() == 0L) {
            return;
        }
        if (this.getStoredEmc() <= this.chargeRate) {
            this.sendToAllAcceptors(this.getStoredEmc());
        } else {
            this.sendToAllAcceptors(this.chargeRate);
        }
    }

    private void chargeItem(ItemStack chargeable) {
        long toSend;
        IItemEmc itemEmc = (IItemEmc)chargeable.func_77973_b();
        long starEmc = itemEmc.getStoredEmc(chargeable);
        long maxStarEmc = itemEmc.getMaximumEmc(chargeable);
        long l = toSend = this.getStoredEmc() < this.chargeRate ? this.getStoredEmc() : this.chargeRate;
        if (starEmc + toSend <= maxStarEmc) {
            itemEmc.addEmc(chargeable, toSend);
            this.removeEMC(toSend);
        } else {
            toSend = maxStarEmc - starEmc;
            itemEmc.addEmc(chargeable, toSend);
            this.removeEMC(toSend);
        }
    }

    public double getItemChargeProportion() {
        if (!this.getCharging().func_190926_b() && this.getCharging().func_77973_b() instanceof IItemEmc) {
            return (double)((IItemEmc)this.getCharging().func_77973_b()).getStoredEmc(this.getCharging()) / (double)((IItemEmc)this.getCharging().func_77973_b()).getMaximumEmc(this.getCharging());
        }
        return 0.0;
    }

    public double getInputBurnProportion() {
        if (this.getBurn().func_190926_b()) {
            return 0.0;
        }
        if (this.getBurn().func_77973_b() instanceof IItemEmc) {
            return (double)((IItemEmc)this.getBurn().func_77973_b()).getStoredEmc(this.getBurn()) / (double)((IItemEmc)this.getBurn().func_77973_b()).getMaximumEmc(this.getBurn());
        }
        return (double)this.getBurn().func_190916_E() / (double)this.getBurn().func_77976_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.output.deserializeNBT(nbt.func_74775_l("Output"));
        this.bonusEMC = nbt.func_74769_h("BonusEMC");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("Input", (NBTBase)this.input.serializeNBT());
        nbt.func_74782_a("Output", (NBTBase)this.output.serializeNBT());
        nbt.func_74780_a("BonusEMC", this.bonusEMC);
        return nbt;
    }

    @Override
    public long acceptEMC(@Nonnull EnumFacing side, long toAccept) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) instanceof RelayMK1Tile) {
            return 0L;
        }
        long toAdd = Math.min(this.maximumEMC - this.currentEMC, toAccept);
        this.currentEMC += toAdd;
        return toAdd;
    }

    public void addBonus(@Nonnull EnumFacing side, double bonus) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) instanceof RelayMK1Tile) {
            return;
        }
        this.bonusEMC += bonus;
        if (this.bonusEMC >= 1.0) {
            long extraEMC = (long)this.bonusEMC;
            this.bonusEMC -= (double)extraEMC;
            this.currentEMC += Math.min(this.maximumEMC - this.currentEMC, extraEMC);
        }
    }

    @Override
    public long provideEMC(@Nonnull EnumFacing side, long toExtract) {
        long toRemove = Math.min(this.currentEMC, toExtract);
        this.currentEMC -= toRemove;
        return toRemove;
    }
}

