/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.LeftClickArchangelPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArchangelSmite
extends RingToggle
implements IPedestalItem,
IModeChanger {
    public ArchangelSmite() {
        super("archangel_smite");
        this.func_77625_d(1);
        this.setNoRepair();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void fireVolley(ItemStack stack, EntityPlayer player) {
        for (int i = 0; i < 10; ++i) {
            this.fireArrow(stack, player.field_70170_p, (EntityLivingBase)player, 4.0f);
        }
    }

    @SubscribeEvent
    public void emptyLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        PacketHandler.sendToServer(new LeftClickArchangelPKT());
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock evt) {
        if (!evt.getWorld().field_72995_K && evt.getUseItem() != Event.Result.DENY && !evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            this.fireVolley(evt.getItemStack(), evt.getEntityPlayer());
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            this.fireVolley(stack, player);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K && this.getMode(stack) == 1 && entity instanceof EntityLivingBase) {
            this.fireArrow(stack, world, (EntityLivingBase)entity, 1.0f);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            this.fireArrow(player.func_184586_b(hand), world, (EntityLivingBase)player, 1.0f);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void fireArrow(ItemStack ring, World world, EntityLivingBase shooter, float inaccuracy) {
        EntityHomingArrow arrow = new EntityHomingArrow(world, shooter, 2.0f);
        if (!(shooter instanceof EntityPlayer) || ArchangelSmite.consumeFuel((EntityPlayer)shooter, ring, EMCHelper.getEmcValue(Items.field_151032_g), true)) {
            arrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 3.0f, inaccuracy);
            world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            world.func_72838_d((Entity)arrow);
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.archangelPedCooldown != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                if (!world.func_72872_a(EntityLiving.class, tile.getEffectBounds()).isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(world, (EntityLivingBase)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.field_70165_t = tile.centeredX;
                        arrow.field_70163_u = tile.centeredY + 2.0;
                        arrow.field_70161_v = tile.centeredZ;
                        arrow.field_70159_w = 0.0;
                        arrow.field_70179_y = 0.0;
                        arrow.field_70181_x = 1.0;
                        arrow.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
                        world.func_72838_d((Entity)arrow);
                    }
                }
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.archangelPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.pedestalCooldown.archangelPedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.archangel.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.archangel.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.archangelPedCooldown)}));
        }
        return list;
    }
}

