/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.json;

import java.util.HashSet;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NSSItem
implements NormalizedSimpleStack {
    static final Set<String> seenIds = new HashSet<String>();
    public final String itemName;
    public final int damage;

    NSSItem(String itemName, int damage) {
        this.itemName = itemName;
        this.damage = damage;
    }

    public static NormalizedSimpleStack create(Block block) {
        return NSSItem.create(block, 0);
    }

    public static NormalizedSimpleStack create(Block block, int meta) {
        return NSSItem.create(block.getRegistryName(), meta);
    }

    public static NormalizedSimpleStack create(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return NSSItem.create(stack.func_77973_b(), stack.func_77952_i());
    }

    public static NormalizedSimpleStack create(Item item) {
        return NSSItem.create(item, 0);
    }

    private static NormalizedSimpleStack create(Item item, int meta) {
        return NSSItem.create(item.getRegistryName(), meta);
    }

    private static NormalizedSimpleStack create(ResourceLocation uniqueIdentifier, int damage) {
        if (uniqueIdentifier == null) {
            return null;
        }
        return NSSItem.create(uniqueIdentifier.toString(), damage);
    }

    public static NormalizedSimpleStack create(String itemName, int damage) {
        NSSItem normStack;
        try {
            normStack = new NSSItem(itemName, damage);
        }
        catch (Exception e) {
            PECore.LOGGER.fatal("Could not create NSSItem: {}", (Object)e.getMessage());
            return null;
        }
        seenIds.add(itemName);
        return normStack;
    }

    public int hashCode() {
        return this.itemName.hashCode() ^ this.damage;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NSSItem) {
            NSSItem other = (NSSItem)obj;
            return this.itemName.equals(other.itemName) && this.damage == other.damage;
        }
        return false;
    }

    @Override
    public String json() {
        return String.format("%s|%s", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
    }

    public String toString() {
        return String.format("%s:%s", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
    }
}

