/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.network;

import com.mjr.mjrlegendslib.network.PacketSimpleBase;
import com.mjr.mjrlegendslib.util.ItemUtilities;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.planetprogression.client.gui.GuiSatelliteRocket;
import com.mjr.planetprogression.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.planetprogression.client.handlers.capabilities.IStatsClientCapability;
import com.mjr.planetprogression.data.SatelliteData;
import com.mjr.planetprogression.entities.EntitySatelliteRocket;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import com.mjr.planetprogression.tileEntities.TileEntitySatelliteController;
import com.mjr.planetprogression.tileEntities.TileEntitySatelliteRocketLauncher;
import com.mjr.planetprogression.tileEntities.TileEntityTelescope;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSimplePP
extends PacketSimpleBase {
    private EnumSimplePacket type;
    private List<Object> data;

    public PacketSimplePP() {
    }

    public PacketSimplePP(EnumSimplePacket packetType, int dimID, Object[] data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public PacketSimplePP(EnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("PlanetProgression packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[PlanetProgression] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        IStatsClientCapability stats = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = (IStatsClientCapability)playerBaseClient.getCapability(CapabilityStatsClientHandler.PP_STATS_CLIENT_CAPABILITY, null);
        }
        switch (this.type) {
            case C_UPDATE_UNLOCKED_PLANET_LIST: {
                stats.setUnlockedPlanets(new ArrayList<CelestialBody>());
                for (Object o : this.data) {
                    for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                        if (!((String)o).equalsIgnoreCase(planet.getUnlocalizedName())) continue;
                        stats.addUnlockedPlanets((CelestialBody)planet);
                    }
                    for (Planet planet : GalaxyRegistry.getRegisteredMoons().values()) {
                        if (!((String)o).equalsIgnoreCase(planet.getUnlocalizedName())) continue;
                        stats.addUnlockedPlanets((CelestialBody)planet);
                    }
                }
                break;
            }
            case C_UPDATE_SATELLITE_LIST: {
                String item = (String)this.data.get(3);
                stats.addSatellites(new SatelliteData((Integer)this.data.get(0), (String)this.data.get(1), (Integer)this.data.get(2), item.equalsIgnoreCase("null") ? null : ItemUtilities.stringToItemStack((String)item, (String)"planetprogression:UpdateSatellieList", (boolean)true)));
                break;
            }
            case C_OPEN_SATELLITE_ROCKET_GUI: {
                int entityID = 0;
                Entity entity = null;
                entityID = (Integer)this.data.get(1);
                entity = player.field_70170_p.func_73045_a(entityID);
                if (entity != null && entity instanceof EntitySatelliteRocket) {
                    MCUtilities.getClient().func_147108_a((GuiScreen)new GuiSatelliteRocket((IInventory)player.field_71071_by, (EntitySatelliteRocket)entity));
                }
                player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        block0 : switch (this.type) {
            case S_UPDATE_ROTATION: {
                TileEntity tileAt = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tileAt instanceof TileEntityTelescope)) break;
                TileEntityTelescope machine = (TileEntityTelescope)tileAt;
                if (((Float)this.data.get(1)).floatValue() == 0.0f) {
                    machine.currentRotation += 45.0f;
                    break;
                }
                if (((Float)this.data.get(1)).floatValue() != 1.0f) break;
                machine.currentRotation -= 45.0f;
                break;
            }
            case S_UPDATE_CONTROLLER_SATLLITE_CHANGE: {
                TileEntity tileAt = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                if (!(tileAt instanceof TileEntitySatelliteController)) break;
                TileEntitySatelliteController machine = (TileEntitySatelliteController)tileAt;
                IStatsCapability statsPP = null;
                if (playerBase != null) {
                    statsPP = (IStatsCapability)player.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
                }
                if (((Float)this.data.get(1)).floatValue() == 0.0f) {
                    machine.currentSatelliteNum = machine.currentSatelliteNum == 0 ? 0 : --machine.currentSatelliteNum;
                    machine.markForSatelliteUpdate = true;
                    break;
                }
                if (((Float)this.data.get(1)).floatValue() != 1.0f) break;
                machine.currentSatelliteNum = machine.currentSatelliteNum == statsPP.getSatellites().size() ? statsPP.getSatellites().size() : ++machine.currentSatelliteNum;
                machine.markForSatelliteUpdate = true;
                break;
            }
            case S_UPDATE_SATELLITE_LAUNCHER_GUI: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(1));
                switch ((Integer)this.data.get(0)) {
                    case 1: {
                        if (!(tile instanceof TileEntitySatelliteRocketLauncher)) break block0;
                        TileEntitySatelliteRocketLauncher launchController = (TileEntitySatelliteRocketLauncher)tile;
                        launchController.setLaunchDropdownSelection((Integer)this.data.get(2));
                        break block0;
                    }
                    case 2: {
                        if (!(tile instanceof TileEntitySatelliteRocketLauncher)) break block0;
                        TileEntitySatelliteRocketLauncher launchController = (TileEntitySatelliteRocketLauncher)tile;
                        int bool = (Integer)this.data.get(2);
                        launchController.launchEnabled = bool != 0;
                        launchController.updateRocketOnDockSettings();
                        break block0;
                    }
                }
                break;
            }
            case S_UPDATE_SATELLITE_ROCKET_STATUS: {
                Entity entity2 = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity2 instanceof EntitySatelliteRocket)) break;
                EntitySatelliteRocket rocket = (EntitySatelliteRocket)entity2;
                int subType = (Integer)this.data.get(1);
                switch (subType) {
                    default: 
                }
                rocket.statusValid = rocket.checkLaunchValidity();
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_UPDATE_ROTATION(Side.SERVER, BlockPos.class, Float.class),
        S_UPDATE_CONTROLLER_SATLLITE_CHANGE(Side.SERVER, BlockPos.class, Float.class),
        S_UPDATE_SATELLITE_LAUNCHER_GUI(Side.SERVER, Integer.class, BlockPos.class, Integer.class),
        S_UPDATE_SATELLITE_ROCKET_STATUS(Side.SERVER, Integer.class, Integer.class),
        C_UPDATE_UNLOCKED_PLANET_LIST(Side.CLIENT, String[].class),
        C_UPDATE_SATELLITE_LIST(Side.CLIENT, Integer.class, String.class, Integer.class, String.class),
        C_OPEN_SATELLITE_ROCKET_GUI(Side.CLIENT, Integer.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

