/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.item;

import com.mjr.mjrlegendslib.item.BasicItem;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.PlanetProgression;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResearchPaper
extends BasicItem {
    private String body;

    public ResearchPaper(String name, int number) {
        super("research_paper_" + number);
        this.body = name.toLowerCase();
        this.func_77637_a(PlanetProgression.tab);
    }

    public String getBodyName() {
        return this.body;
    }

    public String getRealBodyName() {
        return TranslateUtilities.translate((String)ResearchPaper.convertBodyNameForLocalization(this.getBodyName()));
    }

    public static String convertBodyNameForLocalization(String input) {
        if (input.contains("eris")) {
            input = "planet.Eris";
        } else if (input.contains("pluto")) {
            input = "planet.Pluto";
        } else if (input.contains("ceres")) {
            input = "planet.Ceres";
        } else if (input.contains("kuiperbelt")) {
            input = "planet.kuiperBelt";
        } else if (input.endsWith("ep")) {
            input = input.substring(0, input.lastIndexOf("ep"));
        }
        return input;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        String name = this.getRealBodyName();
        list.add(EnumColor.YELLOW + name.substring(0, 1).toUpperCase() + name.substring(1));
        if (Config.researchMode == 1) {
            if (Config.generateResearchPaperInLoot && Config.generateResearchPaperInStructure) {
                list.add(EnumColor.AQUA + TranslateUtilities.translate((String)"research.paper.loot.desc"));
                list.add(EnumColor.AQUA + TranslateUtilities.translate((String)"research.paper.woldgen.desc"));
            } else if (Config.generateResearchPaperInLoot) {
                list.add(EnumColor.AQUA + TranslateUtilities.translate((String)"research.paper.loot.desc"));
            } else if (Config.generateResearchPaperInStructure) {
                list.add(EnumColor.AQUA + TranslateUtilities.translate((String)"research.paper.woldgen.desc"));
            }
        } else {
            list.add(EnumColor.AQUA + TranslateUtilities.translate((String)"research.paper.satellite.controller.desc"));
        }
        list.add(EnumColor.BRIGHT_GREEN + TranslateUtilities.translate((String)"research.paper.use.desc"));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(I18n.func_74838_a((String)"item.research_paper") + ".name")).trim();
    }
}

