/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Compilers;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.Frame;
import info.openmods.calc.ICompilerMapFactory;
import info.openmods.calc.executable.ExecutableList;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.AstCompiler;
import info.openmods.calc.parsing.DefaultExecutableListBuilder;
import info.openmods.calc.parsing.ITokenStreamCompiler;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.parsing.PostfixCompiler;
import info.openmods.calc.parsing.SymbolGetPostfixCompilerState;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.INodeFactory;
import info.openmods.calc.parsing.ast.IOperatorDictionary;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.InfixParser;
import info.openmods.calc.parsing.ast.MappedParserState;
import info.openmods.calc.parsing.ast.PrefixParser;
import info.openmods.calc.parsing.node.DefaultExprNodeFactory;
import info.openmods.calc.parsing.node.DummyNode;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.parsing.postfix.BracketPostfixParserStateBase;
import info.openmods.calc.parsing.postfix.IExecutableListBuilder;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.postfix.MappedPostfixParser;
import info.openmods.calc.parsing.token.TokenIterator;
import info.openmods.calc.parsing.token.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BasicCompilerMapFactory<E>
implements ICompilerMapFactory<E, ExprType> {
    public static final String BRACKET_CONSTANT_EVALUATE = "[";
    public static final String MODIFIER_SYMBOL_GET = "@";
    public static final String SYMBOL_PREFIX = "prefix";
    public static final String SYMBOL_INFIX = "infix";

    @Override
    public Compilers<E, ExprType> create(E nullValue, IValueParser<E> valueParser, IOperatorDictionary<Operator<E>> operators, Environment<E> environment) {
        Tokenizer prefixTokenizer = new Tokenizer();
        Tokenizer infixTokenizer = new Tokenizer();
        Tokenizer postfixTokenizer = new Tokenizer();
        for (String operator : operators.allOperatorIds()) {
            prefixTokenizer.addOperator(operator);
            infixTokenizer.addOperator(operator);
            postfixTokenizer.addOperator(operator);
        }
        this.setupPrefixTokenizer(prefixTokenizer);
        this.setupInfixTokenizer(infixTokenizer);
        this.setupPostfixTokenizer(postfixTokenizer);
        DefaultExprNodeFactory<E> exprNodeFactory = this.createExprNodeFactory(valueParser);
        MappedParserState<IExprNode<E>> prefixCompilerState = this.createPrefixCompilerState(operators, exprNodeFactory);
        MappedParserState<IExprNode<E>> infixCompilerState = this.createInfixCompilerState(operators, exprNodeFactory);
        prefixCompilerState.addStateTransition(SYMBOL_INFIX, new ParserSwitchTransition<E>(infixCompilerState));
        prefixCompilerState.addStateTransition(SYMBOL_PREFIX, new ParserSwitchTransition<E>(prefixCompilerState));
        infixCompilerState.addStateTransition(SYMBOL_INFIX, new ParserSwitchTransition<E>(infixCompilerState));
        infixCompilerState.addStateTransition(SYMBOL_PREFIX, new ParserSwitchTransition<E>(prefixCompilerState));
        this.configureCompilerStateCommon(prefixCompilerState, environment);
        this.configureCompilerStateCommon(infixCompilerState, environment);
        HashMap compilers = Maps.newHashMap();
        compilers.put(ExprType.PREFIX, new WrappedCompiler(prefixTokenizer, this.createPrefixParser(prefixCompilerState)));
        compilers.put(ExprType.INFIX, new WrappedCompiler(infixTokenizer, this.createInfixParser(infixCompilerState)));
        compilers.put(ExprType.POSTFIX, new WrappedCompiler(postfixTokenizer, this.createPostfixParser(valueParser, operators, environment)));
        return new Compilers(compilers);
    }

    protected void setupPrefixTokenizer(Tokenizer tokenizer) {
    }

    protected MappedParserState<IExprNode<E>> createCompilerState(IAstParser<IExprNode<E>> parser) {
        return new MappedParserState<IExprNode<E>>(parser){

            @Override
            protected IExprNode<E> createDefaultSymbolNode(String symbol, List<IExprNode<E>> children) {
                return new SymbolCallNode(symbol, children);
            }

            @Override
            protected IModifierStateTransition<IExprNode<E>> createDefaultModifierStateTransition(String modifier) {
                throw new UnsupportedOperationException(modifier);
            }
        };
    }

    protected MappedParserState<IExprNode<E>> createPrefixCompilerState(IOperatorDictionary<Operator<E>> operators, INodeFactory<IExprNode<E>, Operator<E>> exprNodeFactory) {
        PrefixParser<IExprNode<E>, Operator<E>> prefixParser = new PrefixParser<IExprNode<E>, Operator<E>>(operators, exprNodeFactory);
        return this.createCompilerState(prefixParser);
    }

    protected ITokenStreamCompiler<E> createPrefixParser(IParserState<IExprNode<E>> compilerState) {
        return new AstCompiler<E>(compilerState);
    }

    protected void setupInfixTokenizer(Tokenizer tokenizer) {
    }

    protected MappedParserState<IExprNode<E>> createInfixCompilerState(IOperatorDictionary<Operator<E>> operators, INodeFactory<IExprNode<E>, Operator<E>> exprNodeFactory) {
        InfixParser<IExprNode<E>, Operator<E>> infixParser = new InfixParser<IExprNode<E>, Operator<E>>(operators, exprNodeFactory);
        return this.createCompilerState(infixParser);
    }

    protected ITokenStreamCompiler<E> createInfixParser(IParserState<IExprNode<E>> compilerState) {
        return new AstCompiler<E>(compilerState);
    }

    protected void setupPostfixTokenizer(Tokenizer tokenizer) {
        tokenizer.addModifier(MODIFIER_SYMBOL_GET);
    }

    protected ITokenStreamCompiler<E> createPostfixParser(final IValueParser<E> valueParser, final IOperatorDictionary<Operator<E>> operators, Environment<E> env) {
        MappedPostfixParser compiler = new MappedPostfixParser<IExecutable<E>>(){

            @Override
            protected IExecutableListBuilder<IExecutable<E>> createListBuilder() {
                return new DefaultExecutableListBuilder(valueParser, operators);
            }
        };
        MappedPostfixParser<IExecutable<E>> parser = BasicCompilerMapFactory.addSymbolGetState(BasicCompilerMapFactory.addConstantEvaluatorState(valueParser, operators, env, compiler));
        return new PostfixCompiler<E>(parser);
    }

    public static <E> MappedPostfixParser<IExecutable<E>> addConstantEvaluatorState(IValueParser<E> valueParser, IOperatorDictionary<Operator<E>> operators, Environment<E> env, MappedPostfixParser<IExecutable<E>> compiler) {
        return compiler.addBracketStateProvider(BRACKET_CONSTANT_EVALUATE, BasicCompilerMapFactory.createConstantEvaluatorStateProvider(valueParser, operators, env, BRACKET_CONSTANT_EVALUATE));
    }

    public static <E> MappedPostfixParser.IStateProvider<IExecutable<E>> createConstantEvaluatorStateProvider(final IValueParser<E> valueParser, final IOperatorDictionary<Operator<E>> operators, final Environment<E> env, final String openingBracket) {
        return new MappedPostfixParser.IStateProvider<IExecutable<E>>(){

            @Override
            public IPostfixParserState<IExecutable<E>> createState() {
                final DefaultExecutableListBuilder listBuilder = new DefaultExecutableListBuilder(valueParser, operators);
                class ConstantEvaluatorState
                extends BracketPostfixParserStateBase<IExecutable<E>> {
                    ConstantEvaluatorState() {
                        super(iExecutableListBuilder, openingBracket);
                    }

                    @Override
                    protected IExecutable<E> processCompiledBracket(IExecutable<E> compiledExpr) {
                        Frame resultFrame = env.executeIsolated(compiledExpr);
                        ArrayList computedValues = Lists.newArrayList();
                        for (Object value : resultFrame.stack()) {
                            computedValues.add(Value.create(value));
                        }
                        return ExecutableList.wrap(computedValues);
                    }
                }
                return new ConstantEvaluatorState();
            }
        };
    }

    public static <E> MappedPostfixParser<IExecutable<E>> addSymbolGetState(MappedPostfixParser<IExecutable<E>> compiler) {
        return compiler.addModifierStateProvider(MODIFIER_SYMBOL_GET, new MappedPostfixParser.IStateProvider<IExecutable<E>>(){

            @Override
            public IPostfixParserState<IExecutable<E>> createState() {
                return new SymbolGetPostfixCompilerState();
            }
        });
    }

    protected DefaultExprNodeFactory<E> createExprNodeFactory(IValueParser<E> valueParser) {
        return new DefaultExprNodeFactory<E>(valueParser);
    }

    protected void configureCompilerStateCommon(MappedParserState<IExprNode<E>> compilerState, Environment<E> environment) {
    }

    public static class ParserSwitchTransition<E>
    implements ISymbolCallStateTransition<IExprNode<E>> {
        private IParserState<IExprNode<E>> switchState;

        public ParserSwitchTransition(IParserState<IExprNode<E>> switchState) {
            this.switchState = switchState;
        }

        @Override
        public IParserState<IExprNode<E>> getState() {
            return this.switchState;
        }

        @Override
        public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
            Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (String)"Expected one node, got %s", children);
            return new DummyNode<E>(children.get(0));
        }
    }

    private static class WrappedCompiler<E>
    implements Compilers.ICompiler<E> {
        private final Tokenizer tokenizer;
        private final ITokenStreamCompiler<E> compiler;

        private WrappedCompiler(Tokenizer tokenizer, ITokenStreamCompiler<E> compiler) {
            this.tokenizer = tokenizer;
            this.compiler = compiler;
        }

        @Override
        public IExecutable<E> compile(String input) {
            TokenIterator tokens = this.tokenizer.tokenize(input);
            IExecutable<E> result = this.compiler.compile(tokens);
            if (tokens.hasNext()) {
                throw new IllegalStateException("Unconsumed tokens: " + Lists.newArrayList((Iterator)((Object)tokens)));
            }
            return result;
        }
    }
}

