/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGridNode;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.helpers.IContainerCraftingPacket;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperInvItemHandler;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PacketRecipeTransfer
implements IMessage {
    private NBTTagCompound input;
    private NBTTagCompound output;
    private boolean craftingMode;

    public PacketRecipeTransfer() {
    }

    public PacketRecipeTransfer(@Nonnull NBTTagCompound input, NBTTagCompound output, boolean craftingMode) {
        this.input = input;
        this.output = output;
        this.craftingMode = craftingMode;
    }

    public NBTTagCompound getInput() {
        return this.input;
    }

    public NBTTagCompound getOutput() {
        return this.output;
    }

    public boolean getCraftingMode() {
        return this.craftingMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.input = ByteBufUtils.readTag((ByteBuf)buf);
        this.craftingMode = buf.readBoolean();
        if (buf.readBoolean()) {
            this.output = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.input);
        buf.writeBoolean(this.craftingMode);
        if (this.output != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.output);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketRecipeTransfer, IMessage> {
        private Method getPartPatternTerminalMethod;
        private Boolean canSetCraftingRecipe = null;
        private final HashSet<String> possibleSupportedMethodNames = Sets.newHashSet((Object[])new String[]{"getPatternTerminal", "getPart"});
        private final String noSuchMethodErrorMessage = "no such method: " + String.join((CharSequence)" or ", this.possibleSupportedMethodNames);

        public IMessage onMessage(PacketRecipeTransfer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            player.func_71121_q().func_152344_a(() -> {
                if (container instanceof ContainerPatternTerm) {
                    IContainerCraftingPacket cct;
                    IGridNode node;
                    NBTTagCompound currentStack;
                    int i;
                    this.setCraftingRecipe((ContainerPatternTerm)container, message.getCraftingMode());
                    ItemStack[] recipeInputs = new ItemStack[9];
                    ItemStack[] recipeOutputs = null;
                    for (i = 0; i < recipeInputs.length; ++i) {
                        currentStack = message.getInput().func_74775_l("#" + i);
                        recipeInputs[i] = currentStack.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentStack);
                    }
                    if (!message.output.func_82582_d()) {
                        recipeOutputs = new ItemStack[3];
                        for (i = 0; i < recipeOutputs.length; ++i) {
                            currentStack = message.getOutput().func_74775_l("O" + i);
                            recipeOutputs[i] = currentStack.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentStack);
                        }
                    }
                    if ((node = (cct = (IContainerCraftingPacket)container).getNetworkNode()) == null) {
                        return;
                    }
                    IItemHandler craftMatrix = cct.getInventoryByName("crafting");
                    if (message.input != null) {
                        for (int i2 = 0; i2 < craftMatrix.getSlots(); ++i2) {
                            ItemStack currentItem = ItemStack.field_190927_a;
                            if (recipeInputs[i2] != null) {
                                currentItem = recipeInputs[i2].func_77946_l();
                            }
                            ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)i2, (ItemStack)currentItem);
                        }
                        if (recipeOutputs != null && !message.getCraftingMode()) {
                            IItemHandler outputMatrix = cct.getInventoryByName("output");
                            for (int i3 = 0; i3 < outputMatrix.getSlots(); ++i3) {
                                ItemStack currentItem = ItemStack.field_190927_a;
                                if (recipeOutputs[i3] != null) {
                                    currentItem = recipeOutputs[i3].func_77946_l();
                                }
                                ItemHandlerUtil.setStackInSlot((IItemHandler)outputMatrix, (int)i3, (ItemStack)currentItem);
                            }
                        }
                        container.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
                    }
                }
            });
            return null;
        }

        private void setCraftingRecipe(ContainerPatternTerm container, boolean craftingMode) {
            if (Boolean.FALSE.equals(this.canSetCraftingRecipe)) {
                throw new NoSuchMethodError(this.noSuchMethodErrorMessage);
            }
            if (this.getPartPatternTerminalMethod == null) {
                Method[] methods;
                Class<ContainerPatternTerm> clazz = ContainerPatternTerm.class;
                for (Method method : methods = clazz.getMethods()) {
                    String methodName = method.getName();
                    if (!this.possibleSupportedMethodNames.contains(methodName)) continue;
                    this.getPartPatternTerminalMethod = method;
                    this.getPartPatternTerminalMethod.setAccessible(true);
                    if (this.getPartPatternTerminalMethod.getParameters().length > 0) continue;
                    this.canSetCraftingRecipe = true;
                    break;
                }
                if (this.getPartPatternTerminalMethod == null) {
                    this.canSetCraftingRecipe = false;
                }
            }
            if (this.getPartPatternTerminalMethod == null) {
                throw new NoSuchMethodError(this.noSuchMethodErrorMessage);
            }
            try {
                PartPatternTerminal patternTerminal = (PartPatternTerminal)this.getPartPatternTerminalMethod.invoke((Object)container, new Object[0]);
                patternTerminal.setCraftingRecipe(craftingMode);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new NoSuchMethodError(this.noSuchMethodErrorMessage);
            }
        }
    }
}

