/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftingTerm;
import com.github.vfyjxf.nee.container.ContainerCraftingAmount;
import com.github.vfyjxf.nee.network.NEEGuiHandler;
import com.github.vfyjxf.nee.utils.GuiUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOpenCraftAmount
implements IMessage {
    private NBTTagCompound recipe;
    private boolean isWirelessTerm;
    private boolean isBauble;
    private int wctSlot = -1;

    public PacketOpenCraftAmount() {
    }

    public PacketOpenCraftAmount(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public PacketOpenCraftAmount(NBTTagCompound recipe, boolean isBauble, int wctSlot) {
        this.recipe = recipe;
        this.isBauble = isBauble;
        this.wctSlot = wctSlot;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
        this.isWirelessTerm = buf.readBoolean();
        if (this.isWirelessTerm) {
            this.isBauble = buf.readBoolean();
            this.wctSlot = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
        if (this.wctSlot >= 0) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.isBauble);
            buf.writeInt(this.wctSlot);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketOpenCraftAmount, IMessage> {
        public IMessage onMessage(PacketOpenCraftAmount message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            player.func_71121_q().func_152344_a(() -> {
                if (container instanceof ContainerCraftingTerm) {
                    ContainerOpenContext context = ((ContainerCraftingTerm)container).getOpenContext();
                    if (context != null) {
                        TileEntity tile = context.getTile();
                        NEEGuiHandler.openGui((EntityPlayer)player, 0, tile, context.getSide());
                        if (player.field_71070_bA instanceof ContainerCraftingAmount) {
                            ContainerCraftingAmount cca = (ContainerCraftingAmount)player.field_71070_bA;
                            if (message.recipe != null && !message.recipe.func_82582_d()) {
                                NBTTagCompound resultTag = message.recipe.func_74775_l("O");
                                ItemStack result = resultTag.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(resultTag);
                                cca.setResultStack(result);
                                cca.getResultSlot().func_75215_d(result);
                                cca.setRecipe(message.recipe);
                            }
                            cca.func_75142_b();
                        }
                    }
                } else if (GuiUtils.isWirelessCraftingTermContainer(container)) {
                    NEEGuiHandler.openGui((EntityPlayer)player, 102, player.field_70170_p);
                    if (player.field_71070_bA instanceof ContainerCraftingAmount) {
                        ContainerCraftingAmount cca = (ContainerCraftingAmount)player.field_71070_bA;
                        if (message.recipe != null) {
                            NBTTagCompound resultTag = message.recipe.func_74775_l("O");
                            ItemStack result = resultTag.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(resultTag);
                            cca.setResultStack(result);
                            cca.getResultSlot().func_75215_d(result);
                            cca.setRecipe(message.recipe);
                        }
                        if (message.isWirelessTerm) {
                            cca.setBauble(message.isBauble);
                            cca.setWctSlot(message.wctSlot);
                        }
                        cca.func_75142_b();
                    }
                }
            });
            return null;
        }
    }
}

