/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.client.gui.AEBaseGui;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.implementations.ContainerPatternTerm;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.jei.CraftingTransferHandler;
import com.github.vfyjxf.nee.jei.NEEGhostIngredientHandler;
import com.github.vfyjxf.nee.jei.PatternTransferHandler;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.collect.Table;
import mezz.jei.recipes.RecipeTransferRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public class NEEJeiPlugin
implements IModPlugin {
    private static final Class wctContainer;

    public void register(IModRegistry registry) {
        this.replaceTransferHandler((RecipeTransferRegistry)registry.getRecipeTransferRegistry());
        registry.addGhostIngredientHandler(AEBaseGui.class, (IGhostIngredientHandler)new NEEGhostIngredientHandler());
    }

    private void replaceTransferHandler(RecipeTransferRegistry registry) {
        WrappedTable handlers = Table.hashBasedTable();
        int replaceCount = 0;
        ArrayList<Class> replaceKeys = new ArrayList<Class>(Arrays.asList(ContainerCraftingTerm.class, ContainerPatternTerm.class));
        if (wctContainer != null) {
            replaceKeys.add(wctContainer);
        }
        for (Table.Cell cell : registry.getRecipeTransferHandlers().cellSet()) {
            if (replaceKeys.contains(cell.getRowKey())) {
                ++replaceCount;
                continue;
            }
            handlers.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
        if (replaceCount > 0) {
            handlers.put(ContainerPatternTerm.class, "universal recipe transfer handler", new PatternTransferHandler());
            handlers.put(ContainerCraftingTerm.class, "minecraft.crafting", new CraftingTransferHandler<ContainerCraftingTerm>(ContainerCraftingTerm.class));
            NotEnoughEnergistics.logger.info("Replace AE2 integration successfully!(Registered prior)");
            if (wctContainer != null) {
                handlers.put(wctContainer, "minecraft.crafting", new CraftingTransferHandler(wctContainer));
                NotEnoughEnergistics.logger.info("Replace Wireless Crafting Terminal integration successfully!(Registered prior");
            }
        }
        if (replaceCount < replaceKeys.size()) {
            handlers = new WrappedTable(handlers);
        }
        ObfuscationReflectionHelper.setPrivateValue(RecipeTransferRegistry.class, (Object)registry, handlers, (String)"recipeTransferHandlers");
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("p455w0rd.wct.container.ContainerWCT");
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        wctContainer = clazz;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class WrappedTable<R, C, V>
    extends Table<R, C, V> {
        private static final Field f_modifiers;
        private static final Field f_table;
        private static final Field f_rowMappingFunction;
        private final Table<R, C, V> wrapped;

        public WrappedTable(Table<R, C, V> wrapped) {
            super(new HashMap(), HashMap::new);
            this.wrapped = wrapped;
            try {
                f_table.set((Object)this, f_table.get(wrapped));
                f_rowMappingFunction.set((Object)this, f_rowMappingFunction.get(wrapped));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to do reflection things.", e);
            }
        }

        public Pair<C, V> onValueSet(R row, C col, V value) {
            String canonicalName = value.getClass().getCanonicalName();
            if (row == ContainerPatternTerm.class && "appeng.integration.modules.jei.RecipeTransferHandler".equals(canonicalName)) {
                col = "universal recipe transfer handler";
                value = new PatternTransferHandler();
                NotEnoughEnergistics.logger.info("Pattern terminal transfer handler replaced successfully (Overwrite Denied)");
            }
            if (row == ContainerCraftingTerm.class && "appeng.integration.modules.jei.RecipeTransferHandler".equals(canonicalName)) {
                col = "minecraft.crafting";
                value = new CraftingTransferHandler<ContainerCraftingTerm>(ContainerCraftingTerm.class);
                NotEnoughEnergistics.logger.info("Crafting terminal transfer handler replaced successfully (Overwrite Denied)");
            }
            if (wctContainer != null && row == wctContainer && "p455w0rd.wct.integration.JEI.RecipeTransferHandler".equals(canonicalName)) {
                col = "minecraft.crafting";
                value = new CraftingTransferHandler(wctContainer);
                NotEnoughEnergistics.logger.info("Wireless crafting terminal transfer handler replaced successfully (Overwrite Denied)");
            }
            return Pair.of(col, value);
        }

        public V computeIfAbsent(R row, C col, Supplier<V> valueSupplier) {
            Map<C, Object> rowMap = this.getRow(row);
            Pair pair = this.onValueSet(row, col, valueSupplier.get());
            return (V)rowMap.computeIfAbsent(pair.getLeft(), k -> pair.getRight());
        }

        public V put(R row, C col, V val) {
            Map<C, Object> rowMap = this.getRow(row);
            Pair<C, V> pair = this.onValueSet(row, col, val);
            return (V)rowMap.put(pair.getLeft(), pair.getRight());
        }

        public V get(R row, C col) {
            return (V)this.wrapped.get(row, col);
        }

        public Map<C, V> getRow(R row) {
            return this.wrapped.getRow(row);
        }

        public ImmutableTable<R, C, V> toImmutable() {
            return this.wrapped.toImmutable();
        }

        private static void makeWriteable(Field field) throws IllegalAccessException {
            if ((field.getModifiers() & 0x10) != 0) {
                f_modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
            }
        }

        static {
            try {
                f_modifiers = Field.class.getDeclaredField("modifiers");
                f_modifiers.setAccessible(true);
                f_table = Table.class.getDeclaredField("table");
                f_table.setAccessible(true);
                WrappedTable.makeWriteable(f_table);
                f_rowMappingFunction = Table.class.getDeclaredField("rowMappingFunction");
                f_rowMappingFunction.setAccessible(true);
                WrappedTable.makeWriteable(f_rowMappingFunction);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Unable to do reflection things.", e);
            }
        }
    }
}

