/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import com.github.vfyjxf.nee.config.KeyBindings;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.jei.CraftingTransferHandler;
import com.github.vfyjxf.nee.utils.IngredientStatus;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class CraftingInfoError
implements IRecipeTransferError {
    private final boolean crafting;
    private final RecipeAnalyzer analyzer;

    public CraftingInfoError(RecipeAnalyzer analyzer, boolean isCrafting) {
        this.analyzer = analyzer;
        this.crafting = isCrafting;
    }

    @Nonnull
    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.USER_FACING;
    }

    public void showError(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        this.analyzer.update();
        List<RecipeAnalyzer.RecipeIngredient> ingredients = this.analyzer.analyzeRecipe(recipeLayout);
        for (RecipeAnalyzer.RecipeIngredient ingredient2 : ingredients) {
            if (ingredient2.getStatus() == IngredientStatus.CRAFTABLE) {
                ingredient2.drawHighlight(minecraft, NEEConfig.getCraftableHighlightColor(), recipeX, recipeY);
                continue;
            }
            if (ingredient2.getStatus() != IngredientStatus.MISSING) continue;
            ingredient2.drawHighlight(minecraft, NEEConfig.getMissingHighlightColor(), recipeX, recipeY);
        }
        boolean autoCraftingAvailable = false;
        boolean patternExists = false;
        boolean missingItems = false;
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.crafting) {
            if (!CraftingTransferHandler.isIsPatternInterfaceExists()) {
                autoCraftingAvailable = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.CRAFTABLE);
                missingItems = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.MISSING);
            }
        } else {
            patternExists = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.CRAFTABLE);
        }
        if (autoCraftingAvailable) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text1", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.AUTO_CRAFT_WITH_PREVIEW.func_151463_i())));
        }
        if (patternExists) {
            tooltips.add(TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.pattern", (Object[])new Object[0]));
        }
        if (missingItems) {
            tooltips.add(TextFormatting.RED + I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]));
        }
        if (CraftingTransferHandler.isIsPatternInterfaceExists()) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text2", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.AUTO_CRAFT_WITH_PREVIEW.func_151463_i())));
        }
        TooltipRenderer.drawHoveringText((Minecraft)minecraft, tooltips, (int)mouseX, (int)mouseY);
    }
}

