/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client.gui.widgets;

import com.github.vfyjxf.nee.helper.PreferenceHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class ItemWidget
extends Gui {
    private boolean visible;
    private boolean isSelected;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private boolean isPreferred;
    private final ItemStack ingredient;

    public ItemWidget(ItemStack ingredient, int posX, int posY) {
        this.ingredient = ingredient;
        this.posX = posX;
        this.posY = posY;
        this.width = 18;
        this.height = 18;
        this.visible = true;
        this.isPreferred = PreferenceHelper.isPreferItem(ingredient);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void updatePosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.visible && mouseX >= this.posX && mouseX <= this.posX + this.width && mouseY >= this.posY && mouseY <= this.posY + this.height;
    }

    public void drawWidget(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            FontRenderer fontRenderer = this.ingredient.func_77973_b().getFontRenderer(this.ingredient);
            if (fontRenderer == null) {
                fontRenderer = mc.field_71466_p;
            }
            GlStateManager.func_179126_j();
            this.field_73735_i += 300.0f;
            mc.func_175599_af().field_77023_b += 300.0f;
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_184391_a(null, this.ingredient, this.posX, this.posY);
            mc.func_175599_af().func_180453_a(fontRenderer, this.ingredient, mouseX, mouseY, null);
            GlStateManager.func_179084_k();
            RenderHelper.func_74518_a();
            this.field_73735_i -= 300.0f;
            mc.func_175599_af().field_77023_b -= 300.0f;
            if (this.isPreferred) {
                // empty if block
            }
            if (this.isSelected) {
                GlStateManager.func_179097_i();
                RenderHelper.func_74518_a();
                ItemWidget.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + 16), (int)(this.posY + 16), (int)0x660000FF);
                GlStateManager.func_179126_j();
            }
        }
    }

    public void drawTooltips(Minecraft mc, GuiScreen screen, int mouseX, int mouseY) {
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        if (!this.isSelected) {
            ItemWidget.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + 16), (int)(this.posY + 16), (int)-2130706433);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.func_146283_a(screen.func_191927_a(this.ingredient), mouseX, mouseY);
        GlStateManager.func_179126_j();
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }
}

