/*
 * Decompiled with CFR 0.152.
 */
package moretweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientItem;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import moretweaker.CraftingPart;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class Inputs {
    private Inputs() {
    }

    public static ItemStack[] getStackList(IIngredient ingredient) {
        if (ingredient == null) {
            return new ItemStack[0];
        }
        if (ingredient instanceof IItemStack) {
            return new ItemStack[]{InputHelper.toStack((IItemStack)((IItemStack)ingredient))};
        }
        if (ingredient instanceof IOreDictEntry) {
            return (ItemStack[])OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName()).toArray((Object[])new ItemStack[0]);
        }
        if (ingredient instanceof IngredientStack || ingredient instanceof IngredientItem || ingredient instanceof IngredientOr) {
            ItemStack[] stacks = InputHelper.toStacks((IItemStack[])ingredient.getItemArray());
            if (stacks == null) {
                return new ItemStack[0];
            }
            return stacks;
        }
        return new ItemStack[0];
    }

    public static Object getObject(IIngredient ingredient) {
        if (ingredient == null) {
            return ItemStack.field_190927_a;
        }
        if (ingredient instanceof IItemStack) {
            return InputHelper.toStack((IItemStack)((IItemStack)ingredient));
        }
        if (ingredient instanceof IngredientStack && ingredient.getInternal() instanceof IItemStack) {
            ItemStack stack = InputHelper.toStack((IItemStack)((IItemStack)ingredient.getInternal()));
            stack.func_190920_e(ingredient.getAmount());
            return stack;
        }
        if (ingredient instanceof IOreDictEntry) {
            return ((IOreDictEntry)ingredient).getName();
        }
        if (ingredient instanceof IngredientStack || ingredient instanceof IngredientItem || ingredient instanceof IngredientOr) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (IItemStack stack : ingredient.getItems()) {
                list.add(InputHelper.toStack((IItemStack)stack));
            }
            return list;
        }
        return ItemStack.field_190927_a;
    }

    public static Object[] getObjects(IIngredient[] ingredients) {
        Object[] objects = new Object[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            objects[i] = Inputs.getObject(ingredients[i]);
        }
        return objects;
    }

    public static Object[] getShapedObjects(IIngredient[][] ingredients) {
        char[][] chars = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        HashMap<Character, Object> inputs = new HashMap<Character, Object>();
        if (ingredients.length < 1 || ingredients.length > 3) {
            CraftTweakerAPI.logError((String)("Could not generate shaped objects as of invalid input length: " + ingredients.length));
            return new Object[0];
        }
        int length = -1;
        for (int i = 0; i < ingredients.length; ++i) {
            if (length < 0) {
                if (ingredients[i].length < 1 || ingredients[i].length > 3) {
                    CraftTweakerAPI.logError((String)("Could not generate shaped objects as of invalid input length: " + ingredients[i].length));
                    return new Object[0];
                }
                length = ingredients[i].length;
            } else if (ingredients[i].length != length) {
                CraftTweakerAPI.logError((String)("Could not generate shaped objects as of different input lengths: " + length + ", " + ingredients[i].length));
                return new Object[0];
            }
            for (int j = 0; j < ingredients[i].length; ++j) {
                inputs.put(Character.valueOf(chars[i][j]), Inputs.getObject(ingredients[i][j]));
            }
        }
        String[] strs = new String[ingredients.length];
        block6: for (int i = 0; i < ingredients.length; ++i) {
            switch (length) {
                case 3: {
                    strs[i] = "" + chars[i][0] + chars[i][1] + chars[i][2];
                    continue block6;
                }
                case 2: {
                    strs[i] = "" + chars[i][0] + chars[i][1];
                    continue block6;
                }
                default: {
                    strs[i] = "" + chars[i][0];
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(strs));
        for (Character chr : inputs.keySet()) {
            list.add((String)((Object)chr));
            list.add((String)inputs.get(chr));
        }
        return list.toArray(new Object[0]);
    }

    public static boolean matchesForRemoval(Object obj, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (obj instanceof ItemStack) {
            if (((ItemStack)obj).func_190926_b() && stack.func_190926_b()) {
                return true;
            }
            return ((ItemStack)obj).func_77973_b() == stack.func_77973_b() && (((ItemStack)obj).func_77960_j() == stack.func_77960_j() || ((ItemStack)obj).func_77960_j() == Short.MAX_VALUE) && ItemStack.func_77970_a((ItemStack)((ItemStack)obj), (ItemStack)stack);
        }
        if (obj instanceof Item) {
            return obj == stack.func_77973_b();
        }
        if (obj instanceof Block) {
            return Item.func_150898_a((Block)((Block)obj)) == stack.func_77973_b();
        }
        if (obj instanceof String) {
            for (ItemStack entry : OreDictionary.getOres((String)((String)obj))) {
                if (!Inputs.matchesForRemoval((Object)entry, stack)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof List) {
            for (Object entry : (List)obj) {
                if (!Inputs.matchesForRemoval(entry, stack)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean matchesForRemoval(Object obj, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!Inputs.matchesForRemoval(obj, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesForRemoval(Object obj, ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (!Inputs.matchesForRemoval(obj, stack)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matchesForRemoval(Object obj, Iterable<T> stacks, Function<T, ItemStack> action) {
        for (T stack : stacks) {
            if (!Inputs.matchesForRemoval(obj, action.apply(stack))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matchesForRemovalArray(Object obj, Iterable<T> stacks, Function<T, ItemStack[]> action) {
        for (T stack : stacks) {
            if (!Inputs.matchesForRemoval(obj, action.apply(stack))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matchesForRemovalFlat(Object obj, Iterable<T> stacks, Function<T, Iterable<ItemStack>> action) {
        for (T stack : stacks) {
            if (!Inputs.matchesForRemoval(obj, action.apply(stack))) continue;
            return true;
        }
        return false;
    }

    public static Ingredient getIngredient(Object ingredient) {
        if (ingredient == null) {
            return Ingredient.field_193370_a;
        }
        if (ingredient instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)ingredient});
        }
        if (ingredient instanceof String) {
            return new OreIngredient((String)ingredient);
        }
        if (ingredient instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)ingredient));
        }
        if (ingredient instanceof Block) {
            return Ingredient.func_193367_a((Item)Item.func_150898_a((Block)((Block)ingredient)));
        }
        if (ingredient instanceof List) {
            ArrayList<Ingredient> converted = new ArrayList<Ingredient>();
            for (Object o : (List)ingredient) {
                converted.add(Inputs.getIngredient(o));
            }
            return Ingredient.merge(converted);
        }
        return Ingredient.field_193370_a;
    }

    public static Ingredient[] getIngredients(Object[] ingredients) {
        Ingredient[] objects = new Ingredient[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            objects[i] = Inputs.getIngredient(ingredients[i]);
        }
        return objects;
    }

    public static CraftingPart getPart(IIngredient obj) {
        if (obj instanceof IItemStack) {
            ItemStack stack = InputHelper.toStack((IItemStack)((IItemStack)obj));
            return new CraftingPart(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), stack.func_190916_E());
        }
        if (obj instanceof IngredientStack && obj.getInternal() instanceof IItemStack) {
            ItemStack stack = InputHelper.toStack((IItemStack)((IItemStack)obj.getInternal()));
            return new CraftingPart(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), obj.getAmount());
        }
        if (obj instanceof IOreDictEntry) {
            if (!OreDictionary.doesOreNameExist((String)((IOreDictEntry)obj).getName())) {
                return CraftingPart.EMPTY;
            }
            return new CraftingPart((Ingredient)new OreIngredient(((IOreDictEntry)obj).getName()), obj.getAmount());
        }
        if (obj instanceof IngredientStack && obj.getInternal() instanceof IOreDictEntry) {
            if (!OreDictionary.doesOreNameExist((String)((IOreDictEntry)obj.getInternal()).getName())) {
                return CraftingPart.EMPTY;
            }
            return new CraftingPart((Ingredient)new OreIngredient(((IOreDictEntry)obj.getInternal()).getName()), obj.getAmount());
        }
        if (obj instanceof IngredientOr && obj.getInternal() instanceof IIngredient[]) {
            List stacks = obj.getItems();
            int amount = -1;
            for (IItemStack stack : stacks) {
                if (amount == -1) {
                    amount = stack.getAmount();
                    continue;
                }
                if (amount == -2 || amount == stack.getAmount()) continue;
                CraftTweakerAPI.logWarning((String)("Could not retain stack-size for " + obj.toString() + " when converting to CraftingPart. Using 1 instead."));
                amount = -2;
            }
            if (amount < 0) {
                amount = 1;
            }
            IIngredient[] parts = (IIngredient[])obj.getInternal();
            ArrayList<Ingredient> parts2 = new ArrayList<Ingredient>();
            for (IIngredient part : parts) {
                parts2.add(Inputs.getPart((IIngredient)part).ingredient);
            }
            return new CraftingPart((Ingredient)new CompoundIngredient(parts2){}, amount);
        }
        if (obj instanceof IngredientStack || obj instanceof IngredientItem || obj instanceof IngredientOr) {
            List stacks = obj.getItems();
            ArrayList<ItemStack> stacks2 = new ArrayList<ItemStack>();
            int amount = -1;
            for (IItemStack stack : stacks) {
                if (amount == -1) {
                    amount = stack.getAmount();
                } else if (amount != -2 && amount != stack.getAmount()) {
                    CraftTweakerAPI.logWarning((String)("Could not retain stack-size for " + obj.toString() + " when converting to CraftingPart. Using 1 instead."));
                    amount = -2;
                }
                stacks2.add(InputHelper.toStack((IItemStack)stack));
            }
            if (amount < 0) {
                amount = 1;
            }
            return new CraftingPart(Ingredient.func_193369_a((ItemStack[])stacks2.toArray(new ItemStack[0])), amount);
        }
        return CraftingPart.EMPTY;
    }

    public static CraftingPart[] getParts(IIngredient[] obj) {
        CraftingPart[] parts = new CraftingPart[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            parts[i] = Inputs.getPart(obj[i]);
        }
        return parts;
    }
}

