/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile.base;

import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import javax.annotation.Nullable;
import mekanism.api.IHeatTransfer;
import modulardiversity.components.requirements.RequirementMekHeat;
import modulardiversity.util.HeatUtils;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public abstract class TileEntityMekHeat
extends TileColorableMachineComponent
implements MachineComponentTile,
IHeatTransfer,
ITickable,
ICraftingResourceHolder<RequirementMekHeat.ResourceToken> {
    public double temperature;
    public double heatToAbsorb = 0.0;
    @CapabilityInject(value=IHeatTransfer.class)
    public static Capability<IHeatTransfer> HEAT_TRANSFER_CAPABILITY = null;

    public double getTemp() {
        return this.temperature;
    }

    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    public double getInsulationCoefficient(EnumFacing side) {
        return 1000.0;
    }

    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    public boolean canConnectHeat(EnumFacing side) {
        return true;
    }

    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (adj != null && adj.hasCapability(HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return (IHeatTransfer)adj.getCapability(HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.simulateHeat();
            this.applyTemperatureChange();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public String getInputProblem(RequirementMekHeat.ResourceToken token) {
        return "craftcheck.mekheat.input";
    }

    @Override
    public String getOutputProblem(RequirementMekHeat.ResourceToken token) {
        return "craftcheck.mekheat.output";
    }
}

