/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile;

import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nullable;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementMysticalMechanics;
import modulardiversity.tile.base.TileEntityMysticalMechanics;
import modulardiversity.util.ConsumerMechCapability;
import modulardiversity.util.ICraftingResourceHolder;
import mysticalmechanics.api.IMechCapability;
import net.minecraft.nbt.NBTTagCompound;

public class TileMysticalMechanicsInput
extends TileEntityMysticalMechanics {
    @Override
    protected IMechCapability initCapability() {
        return new ConsumerMechCapability();
    }

    @Override
    public boolean consume(RequirementMysticalMechanics.ResourceToken token, boolean doConsume) {
        double power = this.capability.getPower(null);
        if (token.getRequiredLevelMin() > power || token.getRequiredLevelMax() < power) {
            return false;
        }
        token.setRequiredlevelMet();
        return true;
    }

    @Override
    public boolean generate(RequirementMysticalMechanics.ResourceToken token, boolean doGenerate) {
        return false;
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponents.MysticalMechanicsHatch(MachineComponent.IOType.INPUT){

            public ICraftingResourceHolder<RequirementMysticalMechanics.ResourceToken> getContainerProvider() {
                return TileMysticalMechanicsInput.this;
            }
        };
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        ConsumerMechCapability capability = (ConsumerMechCapability)this.capability;
        for (int i = 0; i < 6; ++i) {
            capability.power[i] = compound.func_74769_h("mech_power" + i);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        ConsumerMechCapability capability = (ConsumerMechCapability)this.capability;
        for (int i = 0; i < 6; ++i) {
            compound.func_74780_a("mech_power" + i, capability.power[i]);
        }
    }
}

