/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.jei.JEIHelpers;
import modulardiversity.jei.ingredients.MekHeat;
import modulardiversity.util.HeatUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class RendererMekHeat
implements IIngredientRenderer<MekHeat> {
    private IDrawableStatic heat_bar;
    private IDrawableStatic heat_bar_fill;

    private void registerDrawables() {
        if (this.heat_bar == null) {
            this.heat_bar = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 34, 63, 14, 14);
        }
        if (this.heat_bar_fill == null) {
            this.heat_bar_fill = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 20, 63, 14, 14);
        }
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable MekHeat ingredient) {
        this.registerDrawables();
        if (ingredient == null) {
            return;
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.heat_bar.draw(minecraft, xPosition, yPosition);
        long l = System.currentTimeMillis();
        double maxFill = 14.0;
        int currentFill = (int)((double)l / 200.0 % maxFill + 1.0);
        if (ingredient.getTemperature() > 0.0) {
            currentFill = (int)(maxFill - (double)currentFill + 1.0);
        }
        Color heatColor = HeatUtils.getHeatColor(MathHelper.func_151238_b((double)ingredient.getRequiredTemperatureMin(), (double)Math.min(ingredient.getRequiredTemperatureMax(), 100000.0), (double)(1.0 - (double)currentFill / maxFill)));
        GlStateManager.func_179131_c((float)((float)heatColor.getRed() / 255.0f), (float)((float)heatColor.getGreen() / 255.0f), (float)((float)heatColor.getBlue() / 255.0f), (float)((float)heatColor.getAlpha() / 255.0f));
        this.heat_bar_fill.draw(minecraft, xPosition, yPosition, currentFill, 0, 0, 0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
    }

    public List<String> getTooltip(Minecraft minecraft, MekHeat ingredient, ITooltipFlag tooltipFlag) {
        boolean omitMax;
        DecimalFormat requirementFormat = new DecimalFormat("0.##");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setInfinity("\u00e2\u02c6\u017e");
        requirementFormat.setDecimalFormatSymbols(symbols);
        DecimalFormat tickFormat = new DecimalFormat("+0.##;-0.##");
        ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Mekanism Heat"});
        boolean omitMin = ingredient.getRequiredTemperatureMin() <= 0.0;
        boolean bl = omitMax = ingredient.getRequiredTemperatureMax() >= Double.POSITIVE_INFINITY;
        if (!omitMin && !omitMax) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + "Requires between " + requirementFormat.format(ingredient.getRequiredTemperatureMin()) + " and " + requirementFormat.format(ingredient.getRequiredTemperatureMax()) + " heat");
        } else if (!omitMax) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + "Requires less than " + requirementFormat.format(ingredient.getRequiredTemperatureMax()) + " heat");
        } else if (!omitMin) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + "Requires more than " + requirementFormat.format(ingredient.getRequiredTemperatureMin()) + " heat");
        }
        tooltip.add(TextFormatting.LIGHT_PURPLE + "" + tickFormat.format(ingredient.getTemperature()) + " heat/t");
        return tooltip;
    }
}

