/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.jei.JEIHelpers;
import modulardiversity.jei.ingredients.Mana;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RendererMana
implements IIngredientRenderer<Mana> {
    private IDrawableStatic mana_bar;
    private IDrawableStatic mana_bar_fill;

    private void registerDrawables() {
        if (this.mana_bar == null) {
            this.mana_bar = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 28, 0, 5, 63);
        }
        if (this.mana_bar_fill == null) {
            this.mana_bar_fill = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 33, 0, 3, 61);
        }
    }

    public List<String> getTooltip(Minecraft minecraft, Mana ingredient, ITooltipFlag tooltipFlag) {
        return Lists.newArrayList((Object[])new String[]{"Mana"});
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable Mana mana) {
        if (mana == null) {
            return;
        }
        this.registerDrawables();
        GlStateManager.func_179141_d();
        Color color = new Color(Color.HSBtoRGB(0.55f, (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 1.0), 1.0f));
        int consumedMana = mana != null ? mana.getConsumedMana() : 0;
        this.renderManaBar(minecraft, xPosition, yPosition, color.getRGB(), 1.0f, consumedMana, 10000);
        GlStateManager.func_179118_c();
    }

    public void renderManaBar(Minecraft minecraft, int x, int y, int color, float alpha, int mana, int maxMana) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.mana_bar.draw(minecraft, x, y);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 61.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        this.mana_bar_fill.draw(minecraft, x + 1, y + 1);
        Color color_ = new Color(color);
        GL11.glColor4ub((byte)((byte)color_.getRed()), (byte)((byte)color_.getGreen()), (byte)((byte)color_.getBlue()), (byte)((byte)(255.0f * alpha)));
        this.mana_bar_fill.draw(minecraft, x + 1, y + 1, MathHelper.func_76125_a((int)(61 - manaPercentage), (int)0, (int)61), 0, 0, 0);
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }
}

