/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.components.requirements.RequirementLaser;
import modulardiversity.jei.JEIHelpers;
import modulardiversity.jei.ingredients.Laser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class RendererLaser
implements IIngredientRenderer<Laser> {
    private IDrawableStatic laser_bar;
    private IDrawableStatic laser_bar_fill;

    private void registerDrawables() {
        if (this.laser_bar == null) {
            this.laser_bar = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 36, 0, 6, 63);
        }
        if (this.laser_bar_fill == null) {
            this.laser_bar_fill = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 42, 0, 4, 61);
        }
    }

    public List<String> getTooltip(Minecraft minecraft, Laser ingredient, ITooltipFlag tooltipFlag) {
        return Lists.newArrayList((Object[])new String[]{"Laser", TextFormatting.LIGHT_PURPLE + "Requires " + ingredient.getRequiredMicroMJ() / 1000000L + " MJ/t"});
    }

    public void render(Minecraft minecraft, int x, int y, @Nullable Laser laser) {
        this.registerDrawables();
        this.laser_bar.draw(minecraft, x, y);
        long microMJ = laser != null ? laser.getRequiredMicroMJ() : 0L;
        int maxFill = (int)(63L * microMJ / RequirementLaser.highestRequiredMJ);
        if (maxFill == 0 && microMJ > 0L) {
            maxFill = 1;
        }
        long l = System.currentTimeMillis();
        int currentFill = (int)((double)l / 200.0 % (double)maxFill + 1.0);
        GL11.glColor4ub((byte)64, (byte)64, (byte)64, (byte)-1);
        this.laser_bar_fill.draw(minecraft, x + 1, y + 1, 63 - maxFill, 0, 0, 0);
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        this.laser_bar_fill.draw(minecraft, x + 1, y + 1, 63 - currentFill, 0, 0, 0);
    }
}

