/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentModifier;
import modulardiversity.jei.ingredients.Modifier;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementModifier
extends RequirementEnvironmental<Modifier, ResourceToken> {
    public String name;
    public float min;
    public float max;

    public RequirementModifier(MachineComponent.IOType actionType, String name, float min, float max) {
        super(ComponentType.Registry.getComponent((String)"modifier"), actionType);
        this.name = name;
        this.min = min;
        this.max = max;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.failure.modifier";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.name, this.min, this.max);
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        return token.isEmpty();
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return token.isEmpty();
    }

    public ComponentRequirement<Modifier> deepCopy() {
        return new RequirementModifier(this.getActionType(), this.name, this.min, this.max);
    }

    public ComponentRequirement<Modifier> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementModifier(this.getActionType(), this.name, this.min, this.max);
    }

    public ComponentRequirement.JEIComponent<Modifier> provideJEIComponent() {
        return new JEIComponentModifier(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private String name;
        private float min;
        private float max;
        private boolean matched;

        public ResourceToken(String name, float min, float max) {
            this.name = name;
            this.min = min;
            this.max = max;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            float v = Misc.applyModifiers(modifiers, this.name, ioType, 1.0f, false);
            if (v >= this.min && v <= this.max) {
                this.matched = true;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.matched;
        }
    }
}

