/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumeOnce;
import modulardiversity.jei.JEIComponentMekLaser;
import modulardiversity.jei.ingredients.MekLaser;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementMekLaser
extends RequirementConsumeOnce<MekLaser, ResourceToken> {
    public double requiredEnergy;

    public RequirementMekLaser(MachineComponent.IOType actionType, double requiredEnergy) {
        super(ComponentType.Registry.getComponent((String)"meklaser"), actionType);
        this.requiredEnergy = requiredEnergy;
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("meklaser") && component instanceof MachineComponents.MekLaserAcceptor && component.getIOType() == this.getActionType();
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredEnergy);
    }

    public ComponentRequirement deepCopy() {
        return new RequirementMekLaser(this.getActionType(), this.requiredEnergy);
    }

    public ComponentRequirement<MekLaser> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementMekLaser(this.getActionType(), this.requiredEnergy);
    }

    public ComponentRequirement.JEIComponent<MekLaser> provideJEIComponent() {
        return new JEIComponentMekLaser(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        double energy;

        public ResourceToken(double energy) {
            this.energy = energy;
        }

        public double getEnergy() {
            return this.energy;
        }

        public void setEnergy(double energy) {
            this.energy = energy;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.energy = Misc.applyModifiers(modifiers, "meklaser", ioType, this.energy, false);
        }

        @Override
        public boolean isEmpty() {
            return this.energy <= 0.0;
        }
    }
}

