/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentDimension;
import modulardiversity.jei.ingredients.DimensionIngredient;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RequirementDimension
extends RequirementEnvironmental<DimensionIngredient, ResourceToken> {
    private HashSet<Integer> dimensions;

    public RequirementDimension(MachineComponent.IOType actionType, int biome) {
        super(ComponentType.Registry.getComponent((String)"dimension"), actionType);
        this.dimensions = new HashSet();
        this.dimensions.add(biome);
    }

    public RequirementDimension(MachineComponent.IOType actionType, Collection<Integer> dimensions) {
        super(ComponentType.Registry.getComponent((String)"dimension"), actionType);
        this.dimensions = new HashSet<Integer>(dimensions);
    }

    public RequirementDimension(MachineComponent.IOType actionType, int[] dimensions) {
        super(ComponentType.Registry.getComponent((String)"dimension"), actionType);
        this.dimensions = new HashSet();
        for (int dimension : dimensions) {
            this.dimensions.add(dimension);
        }
    }

    public ComponentRequirement<DimensionIngredient> deepCopy() {
        return new RequirementDimension(this.getActionType(), this.dimensions);
    }

    public ComponentRequirement<DimensionIngredient> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementDimension(this.getActionType(), this.dimensions);
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.dimension";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken();
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null && this.isValidDimension(tile.func_145831_w(), tile.func_174877_v())) {
            token.setRequirementMet();
            return true;
        }
        return false;
    }

    private boolean isValidDimension(World world, BlockPos pos) {
        return this.dimensions.contains(world.field_73011_w.getDimension());
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return false;
    }

    public ComponentRequirement.JEIComponent<DimensionIngredient> provideJEIComponent() {
        return new JEIComponentDimension(this);
    }

    public Collection<Integer> getDimensions() {
        return this.dimensions.stream().sorted().collect(Collectors.toList());
    }

    public static class ResourceToken
    implements IResourceToken {
        private boolean requirementMet;

        public void setRequirementMet() {
            this.requirementMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMet;
        }
    }
}

