/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentAura;
import modulardiversity.jei.ingredients.Aura;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aura.AuraHelper;

public class RequirementAura
extends RequirementEnvironmental<Aura, ResourceToken> {
    public String name;
    public float visMin;
    public float visMax;
    public float fluxMin;
    public float fluxMax;
    public float vis;
    public float flux;

    public RequirementAura(MachineComponent.IOType actionType, float visMin, float visMax, float fluxMin, float fluxMax, float vis, float flux) {
        super(ComponentType.Registry.getComponent((String)"vis"), actionType);
        this.visMin = visMin;
        this.visMax = visMax;
        this.fluxMin = fluxMin;
        this.fluxMax = fluxMax;
        this.vis = vis;
        this.flux = flux;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        if (token.visMatched && !token.fluxMatched) {
            return "craftcheck.failure.flux";
        }
        return "craftcheck.failure.vis";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.visMin, this.visMax, this.fluxMin, this.fluxMax, this.vis, this.flux);
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            float vis = AuraHelper.getVis((World)world, (BlockPos)pos);
            float flux = AuraHelper.getFlux((World)world, (BlockPos)pos);
            if (vis <= this.visMax && vis >= this.visMin) {
                token.setVisMatched(true);
            }
            if (flux <= this.fluxMax && flux >= this.fluxMin) {
                token.setFluxMatched(true);
            }
            this.writeAura(world, pos);
        }
        return token.isEmpty();
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            this.writeAura(world, pos);
        }
        return true;
    }

    private void writeAura(World world, BlockPos pos) {
        if (this.vis > 0.0f) {
            AuraHelper.addVis((World)world, (BlockPos)pos, (float)this.vis);
        } else if (this.vis < 0.0f) {
            AuraHelper.drainVis((World)world, (BlockPos)pos, (float)(-this.vis), (boolean)false);
        }
        if (this.flux > 0.0f) {
            AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)this.flux, (boolean)true);
        } else if (this.flux < 0.0f) {
            AuraHelper.drainFlux((World)world, (BlockPos)pos, (float)(-this.flux), (boolean)false);
        }
    }

    public ComponentRequirement<Aura> deepCopy() {
        return new RequirementAura(this.getActionType(), this.visMin, this.visMax, this.fluxMin, this.fluxMax, this.vis, this.flux);
    }

    public ComponentRequirement<Aura> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementAura(this.getActionType(), this.visMin, this.visMax, this.fluxMin, this.fluxMax, this.vis, this.flux);
    }

    public ComponentRequirement.JEIComponent<Aura> provideJEIComponent() {
        return new JEIComponentAura(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        public float visMin;
        public float visMax;
        public float fluxMin;
        public float fluxMax;
        private boolean visMatched;
        private boolean fluxMatched;
        public float vis;
        public float flux;

        public boolean isVisMatched() {
            return this.visMatched;
        }

        public boolean isFluxMatched() {
            return this.fluxMatched;
        }

        public void setVisMatched(boolean visMatched) {
            this.visMatched = visMatched;
        }

        public void setFluxMatched(boolean fluxMatched) {
            this.fluxMatched = fluxMatched;
        }

        public ResourceToken(float visMin, float visMax, float fluxMin, float fluxMax, float vis, float flux) {
            this.visMin = visMin;
            this.visMax = visMax;
            this.fluxMin = fluxMin;
            this.fluxMax = fluxMax;
            this.vis = vis;
            this.flux = flux;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.visMin = Misc.applyModifiers(modifiers, "vis_min", ioType, this.visMin, false);
            this.visMax = Misc.applyModifiers(modifiers, "vis_max", ioType, this.visMax, false);
            this.fluxMin = Misc.applyModifiers(modifiers, "flux_min", ioType, this.fluxMin, false);
            this.fluxMax = Misc.applyModifiers(modifiers, "flux_max", ioType, this.fluxMax, false);
            this.vis = Misc.applyModifiers(modifiers, "vis", ioType, this.vis, false);
            this.flux = Misc.applyModifiers(modifiers, "flux", ioType, this.flux, false);
        }

        @Override
        public boolean isEmpty() {
            return this.visMatched && this.fluxMatched;
        }
    }
}

