/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.javaenforcer;

import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.javaenforcer.JE_Settings;
import com.gendeathrow.mputils.utils.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

public class ModChecker {
    private static HashMap<String, String> incompatableMods = new HashMap();
    private static ArrayList<String> ignore = new ArrayList();

    public static void run() {
        MPUtils.logger.log(Level.INFO, "Checking installed Mods...");
        if (FMLClientHandler.instance().hasOptifine() && !JE_Settings.isOptifineCompatable) {
            String msg = "This Modpack is not compatable with Optifine please uninstall this mod";
            Tools.popUpError(msg, "<html><center><p> This Modpack is not compatable with Optifine <br> <font Color=red>please uninstall this mod </font>", MPUtils.logger);
            throw new RuntimeException(msg);
        }
        ignore.add("FML");
        ignore.add("mcp");
        ignore.add("Forge");
        String[] stringArray = JE_Settings.incompMods;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String modid;
            String incompID = modid = stringArray[i];
            String incompReason = "";
            if (modid.contains(":")) {
                String[] split = modid.split("\\:", 2);
                incompID = split[0].trim();
                incompReason = split[1];
            }
            if (!ignore.contains(incompID)) {
                incompatableMods.put(incompID, incompReason);
                continue;
            }
            if (!ignore.contains(incompID)) continue;
            MPUtils.logger.log(Level.WARN, "Can not Disable " + incompID);
        }
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!incompatableMods.containsKey(mod.getModId()) && !incompatableMods.containsKey(mod.getName())) continue;
            String msg = "This Modpack is not compatable with " + mod.getName() + " please uninstall this mod";
            Tools.popUpError(msg, "<html><center><p> This Modpack is not compatable with " + mod.getName() + " <br> <font Color=red>please uninstall this mod </font> ", MPUtils.logger);
            throw new RuntimeException(msg);
        }
    }
}

