/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.commands.client;

import com.gendeathrow.mputils.commands.MP_BaseCommand;
import com.gendeathrow.mputils.configs.ConfigHandler;
import com.gendeathrow.mputils.utils.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;

public class MP_LookAtDump
extends MP_BaseCommand {
    ArrayList options = new ArrayList<String>(Arrays.asList("nbt", "class", "extendedClass"));

    @Override
    public String getCommand() {
        return null;
    }

    @Override
    public String getUsageSuffix() {
        return " [Args:(nbt, class, extendedClass)]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return true;
    }

    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length >= 1) {
            return this.options;
        }
        return new ArrayList<String>();
    }

    @Override
    public void runCommand(CommandBase command, MinecraftServer server, ICommandSender sender, String[] args) {
    }

    protected String parseStackData(ICommandSender sender, String[] args, Entity lookingAt) {
        boolean nbtFlag = false;
        boolean classFlag = false;
        boolean extendedFlag = false;
        for (String arg : args) {
            if (arg.toLowerCase().trim().equals("extendedclass")) {
                extendedFlag = true;
                continue;
            }
            if (arg.toLowerCase().trim().equals("class")) {
                classFlag = true;
                continue;
            }
            if (!arg.toLowerCase().trim().equals("nbt")) continue;
            nbtFlag = true;
        }
        ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)lookingAt);
        String EntityString = EntityList.func_75621_b((Entity)lookingAt);
        Class<?> clazz = lookingAt.getClass();
        String formattedString = TextFormatting.YELLOW + "Localized Name: " + TextFormatting.RESET + lookingAt.func_145748_c_().func_150254_d() + "\n" + TextFormatting.YELLOW + "StringID: " + TextFormatting.RESET + EntityString + "\n" + TextFormatting.YELLOW + "IntID: " + TextFormatting.RESET + EntityList.getID(lookingAt.getClass()) + "\n" + TextFormatting.YELLOW + "ModID: " + TextFormatting.RESET + (modContainer == null ? "minecraft" : modContainer.getModId()) + "\n";
        String clipboardstring = "Localized Name: " + lookingAt.func_145748_c_().func_150260_c() + ConfigHandler.NEW_LINE;
        clipboardstring = clipboardstring + " StringID: " + EntityString + ConfigHandler.NEW_LINE;
        clipboardstring = clipboardstring + " IntID: " + EntityList.getID(lookingAt.getClass()) + ConfigHandler.NEW_LINE;
        clipboardstring = clipboardstring + " ModID: " + (modContainer == null ? "minecraft" : modContainer.getModId()) + ConfigHandler.NEW_LINE;
        if (classFlag) {
            clipboardstring = clipboardstring + " Class: " + lookingAt.getClass().getCanonicalName() + ConfigHandler.NEW_LINE;
            formattedString = formattedString + TextFormatting.YELLOW + "Class: " + TextFormatting.RESET + clazz.getCanonicalName() + "\n";
        }
        List<Class> extendedClasses = Tools.getAllSuperclasses(clazz);
        if (extendedFlag) {
            clipboardstring = clipboardstring + " ExtendedClasses: [ " + ConfigHandler.NEW_LINE;
            for (Class extendClass : extendedClasses) {
                clipboardstring = clipboardstring + extendClass.getCanonicalName() + ConfigHandler.NEW_LINE;
            }
            clipboardstring = clipboardstring + "]" + ConfigHandler.NEW_LINE;
            formattedString = formattedString + TextFormatting.YELLOW + "Extends: " + TextFormatting.RESET + extendedClasses.size() + "x Classes (on clipboard)\n";
        }
        if (nbtFlag) {
            clipboardstring = clipboardstring + "NBTTag: " + lookingAt.func_189511_e(new NBTTagCompound()).toString();
            formattedString = formattedString + TextFormatting.YELLOW + "NBT: " + TextFormatting.RESET + "Found NBT Data";
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(formattedString, new Object[0]));
        Tools.CopytoClipbard(clipboardstring);
        return null;
    }

    protected String parseStackData(ICommandSender sender, String[] args, World world, IBlockState block, BlockPos blockpos) {
        TileEntity te;
        boolean nbtFlag = false;
        boolean classFlag = false;
        boolean extendedFlag = false;
        for (String arg : args) {
            if (arg.toLowerCase().trim().equals("extendedclass")) {
                extendedFlag = true;
                continue;
            }
            if (arg.toLowerCase().trim().equals("class")) {
                classFlag = true;
                continue;
            }
            if (!arg.toLowerCase().trim().equals("nbt")) continue;
            nbtFlag = true;
        }
        ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)block);
        ResourceLocation registryName = block.func_177230_c().getRegistryName();
        Class<?> clazz = block.func_177230_c().getClass();
        List<Class> extendedClasses = Tools.getAllSuperclasses(clazz);
        String clipboardstring = block.func_177230_c().getRegistryName() + (block.func_177230_c().func_176201_c(block) != 0 ? ":" + block.func_177230_c().func_176201_c(block) : "" + ConfigHandler.NEW_LINE);
        String formattedString = TextFormatting.YELLOW + "Registry Name: " + TextFormatting.RESET + registryName + "\n" + TextFormatting.YELLOW + "  Meta: " + TextFormatting.RESET + block.func_177230_c().func_176201_c(block) + "\n" + TextFormatting.YELLOW + "  ModID: " + TextFormatting.RESET + (modContainer == null ? "minecraft" : modContainer.getModId()) + "\n";
        if (classFlag) {
            clipboardstring = clipboardstring + "Class: " + block.func_177230_c().getClass().getCanonicalName() + ConfigHandler.NEW_LINE;
            formattedString = formattedString + TextFormatting.YELLOW + "  Class: " + TextFormatting.RESET + clazz.getCanonicalName() + "\n" + TextFormatting.YELLOW;
        }
        if (extendedFlag) {
            clipboardstring = clipboardstring + "Extended Classes: [" + ConfigHandler.NEW_LINE;
            for (Class extendClass : extendedClasses) {
                clipboardstring = clipboardstring + extendClass.getCanonicalName() + ConfigHandler.NEW_LINE;
            }
            clipboardstring = clipboardstring + "]" + ConfigHandler.NEW_LINE;
            formattedString = formattedString + TextFormatting.YELLOW + "  Extends: " + TextFormatting.RESET + extendedClasses.size() + "x Classes (on clipboard) \n";
        }
        if (nbtFlag && (te = world.func_175625_s(blockpos)) != null) {
            String nbt = te.func_189515_b(new NBTTagCompound()).toString();
            clipboardstring = clipboardstring + "NBTTag: " + nbt;
            formattedString = formattedString + TextFormatting.YELLOW + "  NBT: " + TextFormatting.RESET + "Found NBT Data\n";
        }
        Tools.CopytoClipbard(clipboardstring);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(formattedString, new Object[0]));
        return null;
    }
}

