/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.mjr.mjrlegendslib.item.ItemTuple;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemUtilities {
    public static ItemStack stringToItemStack(String s, String caller, boolean logging) {
        ItemTuple tuple = ItemUtilities.stringToItem(s, caller, logging);
        return new ItemStack(tuple.item, 1, tuple.meta);
    }

    public static ItemTuple stringToItem(String s, String caller, boolean logging) {
        String name;
        Item item;
        int lastColon = s.lastIndexOf(58);
        int meta = -1;
        if (lastColon > 0) {
            try {
                meta = Integer.parseInt(s.substring(lastColon + 1, s.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((item = Item.func_111206_d((String)(name = meta == -1 ? s : s.substring(0, lastColon)))) == null) {
            if (logging) {
                MessageUtilities.infoMessageToLog("mjrlegendslib", caller + ": unrecognised item name '" + s + "'.");
            }
            return null;
        }
        try {
            Integer.parseInt(name);
            String bName = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
            if (logging) {
                MessageUtilities.infoMessageToLog("mjrlegendslib", caller + ": the use of numeric IDs is discouraged, please use " + bName + " instead of " + name);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ItemTuple(item, meta);
    }

    public static Item getRandomItemFromList(List<Item> items) {
        Random rand = new Random();
        return items.get(rand.nextInt(items.size()));
    }

    public static ItemStack getRandomItemStackFromItemList(List<Item> items) {
        Random rand = new Random();
        return new ItemStack(items.get(rand.nextInt(items.size())), 1, 0);
    }

    public static ItemStack getRandomItemStackMetaFromItemList(List<Item> items) {
        Random rand = new Random();
        int temp = rand.nextInt(items.size());
        return new ItemStack(items.get(temp), 1, temp);
    }

    public static ItemStack getRandomItemStackFromItemStackList(List<ItemStack> items) {
        Random rand = new Random();
        return items.get(rand.nextInt(items.size()));
    }

    public static ItemStack getRandomMetaFromItem(Item item) {
        Random rand = new Random();
        return new ItemStack(item, 1, rand.nextInt(item.func_77612_l()));
    }

    public static ItemStack getRandomMetaFromItem(ItemStack item) {
        Random rand = new Random();
        return new ItemStack(item.func_77973_b(), 1, rand.nextInt(item.func_77973_b().func_77612_l()));
    }
}

