/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.darkmagic;

import java.lang.invoke.MethodHandle;
import leviathan143.loottweaker.common.darkmagic.AbstractAccessors;
import leviathan143.loottweaker.common.lib.LootConditions;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class LootEntryAccessors
extends AbstractAccessors {
    private static final MethodHandle LootEntry$weightGetter;
    private static final MethodHandle LootEntry$weightSetter;
    private static final MethodHandle LootEntry$qualityGetter;
    private static final MethodHandle LootEntry$qualitySetter;
    private static final MethodHandle LootEntry$conditionsGetter;
    private static final MethodHandle LootEntry$conditionsSetter;
    private static final MethodHandle LootEntry$nameSetter;

    public static int getWeight(LootEntry entry) {
        try {
            return LootEntry$weightGetter.invokeExact(entry);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry weight getter method handle", e);
        }
    }

    public static void setWeight(LootEntry entry, int weight) {
        try {
            LootEntry$weightSetter.invokeExact(entry, weight);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry weight setter method handle", e);
        }
    }

    public static int getQuality(LootEntry entry) {
        try {
            return LootEntry$qualityGetter.invokeExact(entry);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry quality getter method handle", e);
        }
    }

    public static void setQuality(LootEntry entry, int quality) {
        try {
            LootEntry$qualitySetter.invokeExact(entry, quality);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry quality setter method handle", e);
        }
    }

    public static LootCondition[] getConditions(LootEntry entry) {
        LootCondition[] conditions = LootEntryAccessors.getConditionsUnsafe(entry);
        return conditions != null ? conditions : LootConditions.NONE;
    }

    public static LootCondition[] getConditionsUnsafe(LootEntry entry) {
        try {
            return LootEntry$conditionsGetter.invokeExact(entry);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry conditions getter method handle", e);
        }
    }

    public static void setConditions(LootEntry entry, LootCondition[] conditions) {
        try {
            LootEntry$conditionsSetter.invokeExact(entry, conditions);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry conditions setter method handle", e);
        }
    }

    public static void setName(LootEntry entry, String name) {
        try {
            LootEntry$nameSetter.invokeExact(entry, name);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke LootEntry name setter method handle", e);
        }
    }

    static {
        try {
            LootEntry$weightGetter = LootEntryAccessors.createFieldGetter(LootEntry.class, "field_186364_c", "weight");
            LootEntry$weightSetter = LootEntryAccessors.createFieldSetter(LootEntry.class, "field_186364_c", "weight");
            LootEntry$qualityGetter = LootEntryAccessors.createFieldGetter(LootEntry.class, "field_186365_d", "quality");
            LootEntry$qualitySetter = LootEntryAccessors.createFieldSetter(LootEntry.class, "field_186365_d", "quality");
            LootEntry$conditionsGetter = LootEntryAccessors.createFieldGetter(LootEntry.class, "field_186366_e", "conditions");
            LootEntry$conditionsSetter = LootEntryAccessors.createFieldSetter(LootEntry.class, "field_186366_e", "conditions");
            LootEntry$nameSetter = LootEntryAccessors.createFieldSetter(LootEntry.class, "entryName");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize test LootEntry accessor method handles", t);
        }
    }
}

