/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.helper;

import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.util.LegacyUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class IngredientHelper {
    public static <V> String getUniqueId(V ingredient) {
        if (ingredient instanceof ItemStack) {
            return ((ItemStack)ingredient).func_77955_b(new NBTTagCompound()).toString();
        }
        IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient);
    }

    public static IIngredientType<?> getIngredientType(List<String> ingredientUidList) {
        for (String ingredientUid : ingredientUidList) {
            if (!IngredientHelper.getItemStackFromUid(ingredientUid).func_190926_b()) {
                return VanillaTypes.ITEM;
            }
            for (IIngredientType ingredientType : JeiUtilitiesPlugin.ingredientRegistry.getRegisteredIngredientTypes()) {
                if (JeiUtilitiesPlugin.ingredientRegistry.getIngredientByUid(ingredientType, ingredientUid) == null) continue;
                return ingredientType;
            }
        }
        return null;
    }

    public static <T> T getNormalize(@Nonnull T ingredient) {
        IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(ingredient);
        Object copy = LegacyUtil.getIngredientCopy(ingredient, (IIngredientHelper)ingredientHelper);
        if (copy instanceof ItemStack) {
            ((ItemStack)copy).func_190920_e(1);
        } else if (copy instanceof FluidStack) {
            ((FluidStack)copy).amount = 1000;
        }
        return (T)copy;
    }

    public static boolean ingredientEquals(Object ingredient1, Object ingredient2) {
        if (ingredient1 == ingredient2) {
            return true;
        }
        if (ingredient1 == null || ingredient2 == null) {
            return false;
        }
        if (ingredient1.getClass() == ingredient2.getClass()) {
            IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(ingredient1);
            return ingredientHelper.getUniqueId(ingredient1).equals(ingredientHelper.getUniqueId(ingredient2));
        }
        return false;
    }

    private static ItemStack getItemStackFromUid(String uid) {
        try {
            NBTTagCompound itemStackAsNbt = JsonToNBT.func_180713_a((String)uid);
            return new ItemStack(itemStackAsNbt);
        }
        catch (NBTException nBTException) {
            return ItemStack.field_190927_a;
        }
    }
}

