/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.bookmark;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.config.RecordMode;
import com.github.vfyjxf.jeiutilities.helper.IngredientHelper;
import com.github.vfyjxf.jeiutilities.helper.ReflectionUtils;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.ingredients.IngredientLookupState;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.InputHandler;
import mezz.jei.input.MouseHelper;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class BookmarkInputHandler {
    private static BookmarkInputHandler instance;
    private RecipesGui recipesGui;
    private RecipeGuiLogic logic;
    private BookmarkList bookmarkList;
    private LeftAreaDispatcher leftAreaDispatcher;
    private IngredientGrid bookmarkIngredientGrid;
    private IngredientGridWithNavigation bookmarkContents;
    private IngredientListBatchRenderer bookmarkIngredientSlots;
    private final IntSet clickHandled = new IntArraySet();
    private IIngredientListElement<?> draggedElement;

    public static BookmarkInputHandler getInstance() {
        if (instance == null) {
            instance = new BookmarkInputHandler();
        }
        return instance;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBookmarkListAdd(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (JeiUtilitiesConfig.getRecordMode() == RecordMode.DISABLE) {
            return;
        }
        if (this.isContainerTextFieldFocused()) {
            return;
        }
        int eventKey = Keyboard.getEventKey();
        if (this.isAddBookmark(eventKey)) {
            if (JeiUtilitiesConfig.getRecordMode() == RecordMode.ENABLE && GuiContainer.func_146272_n()) {
                IClickedIngredient clicked = this.recipesGui.getIngredientUnderMouse(MouseHelper.getX(), MouseHelper.getY());
                if (clicked != null && this.addOrRemoveBookmark(clicked.getValue())) {
                    event.setCanceled(true);
                }
            } else {
                IngredientLookupState state;
                boolean withShift;
                boolean bl = withShift = JeiUtilitiesConfig.getRecordMode() == RecordMode.RESTRICTED;
                if (withShift && !GuiContainer.func_146272_n()) {
                    return;
                }
                Pair<RecipeLayout, Object> output = this.getOutputUnderMouse();
                if (output != null && (state = (IngredientLookupState)ReflectionUtils.getFieldValue(RecipeGuiLogic.class, this.logic, "state")) != null && state.getFocus() != null) {
                    boolean isInputMode = state.getFocus().getMode() == IFocus.Mode.INPUT;
                    String recipeCategoryUid = ((IRecipeCategory)state.getRecipeCategories().get(state.getRecipeCategoryIndex())).getUid();
                    IRecipeWrapper recipeWrapper = (IRecipeWrapper)ReflectionUtils.getFieldValue(RecipeLayout.class, output.getLeft(), "recipeWrapper");
                    RecipeInfo recipeInfo = RecipeInfo.create(IngredientHelper.getNormalize(state.getFocus().getValue()), IngredientHelper.getNormalize(output.getRight()), recipeCategoryUid, state.getRecipeIndex(), isInputMode, recipeWrapper);
                    if (this.addOrRemoveBookmark(recipeInfo)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMouseClicked(GuiScreenEvent.MouseInputEvent.Pre event) {
        int eventButton = Mouse.getEventButton();
        if (eventButton > -1) {
            if (Mouse.getEventButtonState()) {
                if (!this.clickHandled.contains(eventButton)) {
                    if (this.handleBookmarkMove(eventButton)) {
                        this.clickHandled.add(eventButton);
                        event.setCanceled(true);
                        return;
                    }
                    if (this.handleMouseClick(eventButton)) {
                        this.clickHandled.add(eventButton);
                        event.setCanceled(true);
                    }
                }
            } else if (this.clickHandled.contains(eventButton)) {
                this.clickHandled.remove(eventButton);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onKeyPressed(GuiScreenEvent.KeyboardInputEvent.Post event) {
        boolean shouldHandleKey;
        char typedChar = Keyboard.getEventCharacter();
        int eventKey = Keyboard.getEventKey();
        boolean bl = shouldHandleKey = eventKey == 0 && typedChar >= ' ' || Keyboard.getEventKeyState();
        if (!shouldHandleKey) {
            return;
        }
        event.setCanceled(this.handleFocusKeybindings(eventKey));
    }

    @SubscribeEvent
    public void onGuiClosed(GuiOpenEvent event) {
        this.draggedElement = null;
        this.notifyListenersOfChange();
    }

    public IIngredientListElement<?> getDraggedElement() {
        return this.draggedElement;
    }

    private boolean handleMouseClick(int mouseButton) {
        Object ingredient;
        if (this.draggedElement != null) {
            return false;
        }
        IClickedIngredient clicked = this.leftAreaDispatcher.getIngredientUnderMouse(MouseHelper.getX(), MouseHelper.getY());
        if (clicked != null && (ingredient = clicked.getValue()) instanceof RecipeInfo) {
            RecipeInfo recipeInfo = (RecipeInfo)ingredient;
            if (mouseButton == 0) {
                if (JeiUtilitiesConfig.getRecordMode() == RecordMode.DISABLE) {
                    this.recipesGui.show((IFocus)new Focus(IFocus.Mode.OUTPUT, recipeInfo.getResult()));
                    return true;
                }
                if (this.handleInvert(recipeInfo)) {
                    return true;
                }
                this.showRecipe((IFocus)new Focus(recipeInfo.getMode(), recipeInfo.getIngredient()));
                JeiUtilitiesPlugin.getGrid().addHistoryIngredient(recipeInfo.getResult());
                IngredientLookupState state = (IngredientLookupState)ReflectionUtils.getFieldValue(RecipeGuiLogic.class, this.logic, "state");
                if (state != null) {
                    state.setRecipeCategoryIndex(this.getRecipeCategoryIndex(state, recipeInfo.getRecipeCategoryUid()));
                    state.setRecipeIndex(recipeInfo.getRecipeIndex());
                    this.updateRecipes();
                    this.recipesGui.onStateChange();
                    this.clickHandled.add(mouseButton);
                    return true;
                }
            } else if (mouseButton == 1) {
                this.recipesGui.show((IFocus)new Focus(IFocus.Mode.INPUT, recipeInfo.getResult()));
                return true;
            }
        }
        return false;
    }

    private boolean handleFocusKeybindings(int eventKey) {
        Object clickedIngredient;
        IClickedIngredient clicked;
        boolean showRecipe = this.isShowRecipe(eventKey);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(eventKey);
        if ((showRecipe || showUses) && (clicked = this.leftAreaDispatcher.getIngredientUnderMouse(MouseHelper.getX(), MouseHelper.getY())) != null && (clickedIngredient = clicked.getValue()) instanceof RecipeInfo) {
            RecipeInfo recipeInfo = (RecipeInfo)clickedIngredient;
            if (showRecipe) {
                if (JeiUtilitiesConfig.getRecordMode() == RecordMode.DISABLE) {
                    this.recipesGui.show((IFocus)new Focus(IFocus.Mode.OUTPUT, recipeInfo.getResult()));
                    return true;
                }
                if (this.handleInvert(recipeInfo)) {
                    return true;
                }
                this.showRecipe((IFocus)new Focus(recipeInfo.getMode(), recipeInfo.getIngredient()));
                JeiUtilitiesPlugin.getGrid().addHistoryIngredient(recipeInfo.getResult());
                IngredientLookupState state = (IngredientLookupState)ReflectionUtils.getFieldValue(RecipeGuiLogic.class, this.logic, "state");
                if (state != null) {
                    state.setRecipeCategoryIndex(this.getRecipeCategoryIndex(state, recipeInfo.getRecipeCategoryUid()));
                    state.setRecipeIndex(recipeInfo.getRecipeIndex());
                    this.updateRecipes();
                    this.recipesGui.onStateChange();
                    return true;
                }
            } else {
                this.recipesGui.show((IFocus)new Focus(IFocus.Mode.INPUT, recipeInfo.getResult()));
                return true;
            }
        }
        return false;
    }

    private boolean handleBookmarkMove(int eventButton) {
        if (eventButton == 2 && this.draggedElement == null) {
            IIngredientListElement elementUnderMouse = this.bookmarkIngredientGrid.getElementUnderMouse();
            if (elementUnderMouse != null) {
                this.pickUpElement(elementUnderMouse);
                return true;
            }
        } else if (eventButton == 0 || eventButton == 1 || eventButton == 2) {
            int insertIndex;
            if (this.draggedElement == null) {
                return false;
            }
            IIngredientListElement replaceElement = null;
            if (eventButton == 2) {
                replaceElement = this.bookmarkIngredientGrid.getElementUnderMouse();
            }
            if ((insertIndex = this.getInsertIndex()) > -1) {
                if (this.bookmarkList.remove(this.draggedElement.getIngredient())) {
                    this.addElement(insertIndex, this.draggedElement);
                }
                this.draggedElement = null;
                this.notifyListenersOfChange();
                if (replaceElement != null) {
                    this.pickUpElement(replaceElement);
                }
                return true;
            }
        }
        return false;
    }

    private Pair<RecipeLayout, Object> getOutputUnderMouse() {
        List recipeLayouts = (List)ReflectionUtils.getFieldValue(RecipesGui.class, this.recipesGui, "recipeLayouts");
        if (recipeLayouts != null) {
            for (RecipeLayout recipeLayout : recipeLayouts) {
                GuiIngredient clicked = recipeLayout.getGuiIngredientUnderMouse(MouseHelper.getX(), MouseHelper.getY());
                if (clicked == null || clicked.isInput()) continue;
                return Pair.of((Object)recipeLayout, (Object)clicked.getDisplayedIngredient());
            }
        }
        return null;
    }

    private boolean addOrRemoveBookmark(Object value) {
        if (this.bookmarkList.remove(value)) {
            if (this.bookmarkList.isEmpty() && Config.isBookmarkOverlayEnabled()) {
                Config.toggleBookmarkEnabled();
            }
            return true;
        }
        if (!Config.isBookmarkOverlayEnabled()) {
            Config.toggleBookmarkEnabled();
        }
        return this.bookmarkList.add(value);
    }

    private boolean handleInvert(RecipeInfo<?, ?> recipeInfo) {
        if (JeiUtilitiesConfig.getRecordMode() == RecordMode.RESTRICTED) {
            if (!GuiContainer.func_146272_n()) {
                this.recipesGui.show((IFocus)new Focus(IFocus.Mode.OUTPUT, recipeInfo.getResult()));
                return true;
            }
        } else if (GuiContainer.func_146272_n()) {
            this.recipesGui.show((IFocus)new Focus(IFocus.Mode.OUTPUT, recipeInfo.getResult()));
            return true;
        }
        return false;
    }

    private void updateRecipes() {
        try {
            ReflectionUtils.getMethod(RecipeGuiLogic.class, "updateRecipes", Void.TYPE, new Class[0]).invoke((Object)this.logic, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private int getRecipeCategoryIndex(@Nonnull IngredientLookupState state, @Nonnull String recipeCategoryUid) {
        for (IRecipeCategory recipeCategory : state.getRecipeCategories()) {
            if (!recipeCategory.getUid().equals(recipeCategoryUid)) continue;
            return state.getRecipeCategories().indexOf((Object)recipeCategory);
        }
        return 0;
    }

    private <V> void showRecipe(IFocus<V> focus) {
        if (this.logic.setFocus((IFocus)(focus = Focus.check(focus)))) {
            try {
                ReflectionUtils.getMethod(RecipesGui.class, "open", Void.TYPE, new Class[0]).invoke((Object)this.recipesGui, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return false;
        }
        GuiTextField textField = (GuiTextField)ReflectionUtil.getFieldWithClass((Object)gui, GuiTextField.class);
        return textField != null && textField.func_146176_q() && textField.func_146206_l();
    }

    private boolean isAddBookmark(int keycode) {
        return keycode != 0 && KeyBindings.bookmark.func_151463_i() == keycode && KeyBindings.bookmark.getKeyConflictContext().isActive();
    }

    private boolean isShowRecipe(int keycode) {
        return keycode != 0 && KeyBindings.showRecipe.func_151463_i() == keycode && KeyBindings.showRecipe.getKeyConflictContext().isActive();
    }

    private int getFirstItemIndex(List<IIngredientListElement> ingredientList) {
        int firstItemIndex = (Integer)ReflectionUtils.getFieldValue(IngredientGridWithNavigation.class, this.bookmarkContents, "firstItemIndex");
        if (firstItemIndex >= ingredientList.size()) {
            firstItemIndex = 0;
        }
        return firstItemIndex;
    }

    private void pickUpElement(@Nonnull IIngredientListElement<?> element) {
        LinkedList<IIngredientListElement> ingredientList = new LinkedList<IIngredientListElement>(this.bookmarkList.getIngredientList());
        ingredientList.remove(element);
        int firstItemIndex = this.getFirstItemIndex(ingredientList);
        this.bookmarkIngredientSlots.set(firstItemIndex, ingredientList);
        this.draggedElement = element;
    }

    private int getInsertIndex() {
        int mouseX = MouseHelper.getX();
        int mouseY = MouseHelper.getY();
        IngredientListSlot slotUnderMouse = null;
        List allGuiIngredientSlots = this.bookmarkIngredientSlots.getAllGuiIngredientSlots();
        for (IngredientListSlot slot : allGuiIngredientSlots) {
            if (!slot.getArea().contains(mouseX, mouseY)) continue;
            if (slot.getIngredientRenderer() == null) {
                List list = (List)ReflectionUtils.getFieldValue(BookmarkList.class, this.bookmarkList, "list");
                return list.size() - 1;
            }
            slotUnderMouse = slot;
            break;
        }
        if (slotUnderMouse != null) {
            int halfX = slotUnderMouse.getArea().x + slotUnderMouse.getArea().width / 2;
            int slotIndex = this.bookmarkIngredientSlots.getAllGuiIngredientSlots().indexOf(slotUnderMouse);
            return mouseX <= halfX ? slotIndex : slotIndex + 1;
        }
        return -1;
    }

    private void addElement(int index, @Nonnull IIngredientListElement<?> element) {
        for (IIngredientListElement existing : this.bookmarkList.getIngredientList()) {
            if (!IngredientHelper.ingredientEquals(existing.getIngredient(), element.getIngredient())) continue;
            return;
        }
        List list = (List)ReflectionUtils.getFieldValue(BookmarkList.class, this.bookmarkList, "list");
        list.add(index, element.getIngredient());
        this.bookmarkList.getIngredientList().add(index, element);
        this.bookmarkList.saveBookmarks();
    }

    private void notifyListenersOfChange() {
        try {
            ReflectionUtils.getMethod(BookmarkList.class, "notifyListenersOfChange", Void.TYPE, new Class[0]).invoke((Object)this.bookmarkList, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void onInputHandlerSet() {
        this.recipesGui = JeiUtilitiesPlugin.jeiRuntime.getRecipesGui();
        this.logic = (RecipeGuiLogic)ObfuscationReflectionHelper.getPrivateValue(RecipesGui.class, (Object)this.recipesGui, (String)"logic");
        this.bookmarkList = (BookmarkList)ObfuscationReflectionHelper.getPrivateValue(BookmarkOverlay.class, (Object)((BookmarkOverlay)JeiUtilitiesPlugin.jeiRuntime.getBookmarkOverlay()), (String)"bookmarkList");
        this.leftAreaDispatcher = (LeftAreaDispatcher)ObfuscationReflectionHelper.getPrivateValue(InputHandler.class, (Object)JeiUtilitiesPlugin.inputHandler, (String)"leftAreaDispatcher");
        this.bookmarkIngredientGrid = JeiUtilitiesPlugin.bookmarkIngredientGrid;
        this.bookmarkContents = JeiUtilitiesPlugin.bookmarkContents;
        this.bookmarkIngredientSlots = (IngredientListBatchRenderer)ObfuscationReflectionHelper.getPrivateValue(IngredientGrid.class, (Object)this.bookmarkIngredientGrid, (String)"guiIngredientSlots");
    }
}

