/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class WorldCache {
    public final World world;
    private StructureBoundingBox boundingBox;
    private IBlockState[] states;

    public WorldCache(World world, StructureBoundingBox boundingBox) {
        this.world = world;
        this.boundingBox = boundingBox;
        this.states = new IBlockState[boundingBox.func_78883_b() * boundingBox.func_78882_c() * boundingBox.func_78880_d()];
    }

    protected Integer getIndex(BlockPos pos) {
        if (!this.boundingBox.func_175898_b((Vec3i)pos)) {
            return null;
        }
        return ((pos.func_177958_n() - this.boundingBox.field_78897_a) * this.boundingBox.func_78882_c() + (pos.func_177956_o() - this.boundingBox.field_78895_b)) * this.boundingBox.func_78880_d() + (pos.func_177952_p() - this.boundingBox.field_78896_c);
    }

    public IBlockState getBlockState(BlockPos pos) {
        Integer index = this.getIndex(pos);
        if (index == null) {
            return this.world.func_180495_p(pos);
        }
        IBlockState state = this.states[index];
        return state != null ? state : (this.states[index.intValue()] = this.world.func_180495_p(pos));
    }

    public boolean setBlockState(BlockPos pos, IBlockState state, int flags) {
        Integer index;
        boolean b = this.world.func_180501_a(pos, state, flags);
        if (b && (index = this.getIndex(pos)) != null) {
            this.states[index.intValue()] = state;
        }
        return b;
    }
}

